/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.message;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public interface ValueWriter {
    public MessageFormatType getFormatType();

    default public void close() throws IOException {
    }

    default public void flush() throws IOException {
    }

    public void writeBinary(Binary var1) throws IOException;

    public void writeBoolean(Boolean var1) throws IOException;

    public void writeDecimal(BigDecimal var1) throws IOException;

    public void writeDouble(Double var1) throws IOException;

    public void writeEnum(MessageEnum var1) throws IOException;

    public void writeFloat(Float var1) throws IOException;

    public void writeInt(Integer var1) throws IOException;

    public void writeInt64(Long var1) throws IOException;

    public <T> void writeList(List<T> var1, ValueSerializer<T> var2) throws IOException;

    public <K, V> void writeMap(Map<K, V> var1, ValueSerializer<K> var2, ValueSerializer<V> var3) throws IOException;

    public <T extends Message> void writeMessage(T var1, MessageSerializer<T> var2) throws IOException;

    public void writePosition(Position var1) throws IOException;

    public void writePositionTime(PositionTime var1) throws IOException;

    default public <T> void writeSet(Set<T> set, ValueSerializer<T> serializer) throws IOException {
        this.writeList(new ArrayList<T>(set), serializer);
    }

    public void writeText(String var1) throws IOException;

    default public void writeTimestamp(Timestamp value) throws IOException {
        this.writeInt64(value.getTime());
    }

    public void writeVarInt(BigInteger var1) throws IOException;
}

