/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.message;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public interface MessageReader
extends Closeable {
    public MessageFormatType getFormatType();

    @Override
    default public void close() throws IOException {
    }

    public boolean isNext(int var1, String var2) throws IOException;

    public Binary readBinary(int var1, String var2, Binary var3) throws IOException;

    public Boolean readBoolean(int var1, String var2, Boolean var3) throws IOException;

    public BigDecimal readDecimal(int var1, String var2) throws IOException;

    public BigDecimal readDecimal(int var1, String var2, BigDecimal var3) throws IOException;

    public double readDouble(int var1, String var2) throws IOException;

    public Double readDouble(int var1, String var2, Double var3) throws IOException;

    public <T extends MessageEnum> T readEnum(int var1, String var2, MessageEnumSerializer<T> var3) throws IOException;

    public float readFloat(int var1, String var2) throws IOException;

    public Float readFloat(int var1, String var2, Float var3) throws IOException;

    public int readInt(int var1, String var2) throws IOException;

    public Integer readInt(int var1, String var2, Integer var3) throws IOException;

    public long readInt64(int var1, String var2) throws IOException;

    public Long readInt64(int var1, String var2, Long var3) throws IOException;

    public <T> List<T> readList(int var1, String var2, ValueSerializer<T> var3) throws IOException;

    public <K, V> Map<K, V> readMap(int var1, String var2, ValueSerializer<K> var3, ValueSerializer<V> var4) throws IOException;

    public <T extends Message> T readMessage(int var1, String var2, MessageSerializer<T> var3) throws IOException;

    public Position readPosition(int var1, String var2) throws IOException;

    public Position readPosition(int var1, String var2, Position var3) throws IOException;

    public PositionTime readPositionTime(int var1, String var2) throws IOException;

    public PositionTime readPositionTime(int var1, String var2, PositionTime var3) throws IOException;

    public <T> Set<T> readSet(int var1, String var2, ValueSerializer<T> var3) throws IOException;

    public String readText(int var1, String var2, String var3) throws IOException;

    public Timestamp readTimestamp(int var1, String var2) throws IOException;

    public Timestamp readTimestamp(int var1, String var2, Timestamp var3) throws IOException;

    public BigInteger readVarInt(int var1, String var2) throws IOException;

    public BigInteger readVarInt(int var1, String var2, BigInteger var3) throws IOException;
}

