/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.util.logging;

import java.util.function.Function;
import net.maritimecloud.internal.util.logging.JDKLogger;
import net.maritimecloud.internal.util.logging.Logger;
import net.maritimecloud.internal.util.logging.SLF4JLogger;
import org.slf4j.LoggerFactory;

class LogFactory {
    static final Function<Class<?>, Logger> LOG_FACTORY;

    LogFactory() {
    }

    static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        if (LogFactory.classExists("org.slf4j.LoggerXXX")) {
            try {
                Class<?> cl = Class.forName(LogFactory.class.getName() + "$SLF4JFactory");
                LOG_FACTORY = (Function)cl.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
                throw new Error(e2);
            }
        } else {
            LOG_FACTORY = e -> new JDKLogger(java.util.logging.Logger.getLogger(e.getName()));
        }
    }

    static class SLF4JFactory
    implements Function<Class<?>, Logger> {
        SLF4JFactory() {
        }

        @Override
        public Logger apply(Class<?> t) {
            org.slf4j.Logger l = LoggerFactory.getLogger(t);
            return new SLF4JLogger(l);
        }
    }
}

