/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.util.logging;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.maritimecloud.internal.util.logging.AbstractLogger;
import net.maritimecloud.internal.util.logging.Logger;

public class LazyJdkLogger
extends AbstractLogger {
    private final String jdkLoggerName;
    private final String lastCaller;
    private volatile Logger logger;
    private final String msg;

    public LazyJdkLogger(String jdkLoggerName, String msg, String lastCaller) {
        this.msg = Objects.requireNonNull(msg, "msg is null");
        this.jdkLoggerName = Objects.requireNonNull(jdkLoggerName, "jdkLoggerName is null");
        this.lastCaller = Objects.requireNonNull(lastCaller, "lastCaller is null");
    }

    protected Logger createDefaultLogger() {
        Logger logger = LogManager.getLogManager().getLogger(this.jdkLoggerName);
        if (logger == null) {
            logger = Logger.getLogger(this.jdkLoggerName);
            logger.setLevel(Level.ALL);
            logger.log(new LazyLogRecord(Level.INFO, this.msg, this.lastCaller));
            logger.setLevel(Level.WARNING);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger getLogger() {
        Logger logger = this.logger;
        if (logger != null) {
            return logger;
        }
        LazyJdkLogger lazyJdkLogger = this;
        synchronized (lazyJdkLogger) {
            logger = this.logger;
            return logger == null ? (this.logger = this.createDefaultLogger()) : logger;
        }
    }

    @Override
    public String getName() {
        return this.jdkLoggerName;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.getLogger().isLoggable(LazyJdkLogger.toJdkLevel(level));
    }

    @Override
    public void log(Logger.Level level, String message) {
        Logger logger = this.getLogger();
        LazyLogRecord r = new LazyLogRecord(LazyJdkLogger.toJdkLevel(level), message, this.lastCaller);
        logger.log(r);
    }

    @Override
    public void log(Logger.Level level, String message, Throwable cause) {
        Logger logger = this.getLogger();
        LazyLogRecord r = new LazyLogRecord(LazyJdkLogger.toJdkLevel(level), message, this.lastCaller);
        r.setThrown(cause);
        logger.log(r);
    }

    static class LazyLogRecord
    extends LogRecord {
        private static final long serialVersionUID = -5042636617771251558L;
        final String lastCaller;
        private transient boolean sourceInited;

        LazyLogRecord(Level level, String msg, String lastCaller) {
            super(level, msg);
            this.lastCaller = lastCaller;
        }

        @Override
        public String getSourceClassName() {
            this.initSource();
            return super.getSourceClassName();
        }

        @Override
        public String getSourceMethodName() {
            this.initSource();
            return super.getSourceMethodName();
        }

        private void initSource() {
            if (!this.sourceInited) {
                String current;
                int i;
                StackTraceElement[] elements = new Throwable().getStackTrace();
                for (i = 0; i < elements.length && !(current = elements[i].getClassName()).equals(this.lastCaller); ++i) {
                }
                while (++i < elements.length && elements[i].getClassName().equals(this.lastCaller)) {
                }
                if (i < elements.length) {
                    this.setSourceClassName(elements[i].getClassName());
                    this.setSourceMethodName(elements[i].getMethodName());
                }
                this.sourceInited = true;
            }
        }
    }
}

