/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.util.logging;

import java.util.Objects;
import java.util.logging.Logger;
import net.maritimecloud.internal.util.logging.AbstractLogger;
import net.maritimecloud.internal.util.logging.Logger;

final class JDKLogger
extends AbstractLogger {
    final Logger logger;

    JDKLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    public boolean equals(Object obj) {
        return obj instanceof JDKLogger && ((JDKLogger)obj).logger == this.logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    public int hashCode() {
        return this.logger.hashCode();
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.logger.isLoggable(JDKLogger.toJdkLevel(level));
    }

    @Override
    public void log(Logger.Level level, String message) {
        this.logger.log(JDKLogger.toJdkLevel(level), message);
    }

    @Override
    public void log(Logger.Level level, String message, Throwable cause) {
        this.logger.log(JDKLogger.toJdkLevel(level), message, cause);
    }
}

