/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class SecurityTools {
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA512withECDSA";

    public static Signature newSignatureForSigning(PrivateKey key) {
        Signature dsa = SecurityTools.newSignature();
        try {
            dsa.initSign(key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("The specified private key is invalid", e);
        }
        return dsa;
    }

    public static Signature newSignatureForVerify(PublicKey key) {
        Signature dsa = SecurityTools.newSignature();
        try {
            dsa.initVerify(key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("The specified public key is invalid", e);
        }
        return dsa;
    }

    public static Signature newSignature() {
        try {
            return Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA512withECDSA should be installed on all platform", e);
        }
    }
}

