/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.text.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.core.javax.json.JsonArray;
import net.maritimecloud.internal.core.javax.json.JsonNumber;
import net.maritimecloud.internal.core.javax.json.JsonObject;
import net.maritimecloud.internal.core.javax.json.JsonString;
import net.maritimecloud.internal.core.javax.json.JsonValue;
import net.maritimecloud.internal.message.text.AbstractTextValueReader;
import net.maritimecloud.internal.message.text.json.JsonMessageReader;
import net.maritimecloud.internal.message.text.json.JsonStringImpl;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.SerializationException;
import net.maritimecloud.message.ValueSerializer;

public class JsonValueReader
extends AbstractTextValueReader {
    final JsonValue value;

    JsonValueReader(JsonValue value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public Boolean readBoolean() throws IOException {
        if (this.value == JsonValue.TRUE) {
            return Boolean.TRUE;
        }
        if (this.value == JsonValue.FALSE) {
            return Boolean.FALSE;
        }
        throw new SerializationException("Was not a boolean " + this.value.getClass());
    }

    @Override
    public BigDecimal readDecimal() throws IOException {
        if (this.value instanceof JsonNumber) {
            JsonNumber v = (JsonNumber)this.value;
            return v.bigDecimalValue();
        }
        throw new SerializationException("Was not a number");
    }

    @Override
    public Double readDouble() throws IOException {
        if (this.value instanceof JsonNumber) {
            JsonNumber v = (JsonNumber)this.value;
            return v.doubleValue();
        }
        throw new SerializationException("Was not a number");
    }

    @Override
    public Float readFloat() throws IOException {
        if (this.value instanceof JsonNumber) {
            JsonNumber v = (JsonNumber)this.value;
            return Float.valueOf((float)v.doubleValue());
        }
        throw new SerializationException("Was not a number");
    }

    @Override
    public Integer readInt() throws IOException {
        if (this.value instanceof JsonNumber) {
            JsonNumber v = (JsonNumber)this.value;
            return v.intValue();
        }
        throw new SerializationException("Was not a number");
    }

    @Override
    public Long readInt64() throws IOException {
        if (this.value instanceof JsonNumber) {
            JsonNumber v = (JsonNumber)this.value;
            return v.longValue();
        }
        throw new SerializationException("Was not a number");
    }

    @Override
    public <T> List<T> readList(ValueSerializer<T> parser) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        JsonArray a = (JsonArray)this.value;
        for (int i = 0; i < a.size(); ++i) {
            T t = parser.read(new JsonValueReader((JsonValue)a.get(i)));
            result.add(t);
        }
        return result;
    }

    @Override
    public <K, V> Map<K, V> readMap(ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        HashMap<K, V> result = new HashMap<K, V>();
        JsonObject a = (JsonObject)this.value;
        for (Map.Entry e : a.entrySet()) {
            JsonStringImpl kImpl = new JsonStringImpl((String)e.getKey());
            K key = keyParser.read(new JsonValueReader(kImpl));
            V value = valueParser.read(new JsonValueReader((JsonValue)e.getValue()));
            result.put(key, value);
        }
        return result;
    }

    @Override
    public <T extends Message> T readMessage(MessageSerializer<T> parser) throws IOException {
        JsonObject o = (JsonObject)this.value;
        JsonMessageReader r = new JsonMessageReader(o);
        return parser.read(r);
    }

    @Override
    protected String readString() throws IOException {
        if (this.value instanceof JsonString) {
            JsonString v = (JsonString)this.value;
            return v.getString();
        }
        throw new SerializationException("Was not a string");
    }

    @Override
    public BigInteger readVarInt() throws IOException {
        if (this.value instanceof JsonNumber) {
            JsonNumber v = (JsonNumber)this.value;
            return v.bigIntegerValue();
        }
        throw new SerializationException("Was not a number");
    }
}

