/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.text.json;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.core.javax.json.JsonObject;
import net.maritimecloud.internal.core.javax.json.JsonReader;
import net.maritimecloud.internal.core.javax.json.JsonValue;
import net.maritimecloud.internal.core.javax.json.spi.JsonProvider;
import net.maritimecloud.internal.message.AbstractMessageReader;
import net.maritimecloud.internal.message.text.json.JsonValueReader;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.SerializationException;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.message.ValueSerializer;

public class JsonMessageReader
extends AbstractMessageReader {
    final JsonIterator iter;
    final JsonReader r;

    public JsonMessageReader(CharSequence s) {
        this(JsonProvider.provider().createReader(new StringReader(s.toString())));
    }

    @Override
    public final MessageFormatType getFormatType() {
        return MessageFormatType.HUMAN_READABLE;
    }

    public JsonMessageReader(JsonObject o) {
        this.r = null;
        this.iter = new JsonIterator(o);
    }

    public JsonMessageReader(JsonReader r) {
        this.r = Objects.requireNonNull(r);
        this.iter = new JsonIterator(r.readObject());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected ValueReader find(int tag, String name) throws SerializationException {
        if (this.isNext(-1, name)) {
            return new JsonValueReader(this.iter.next().getValue());
        }
        throw new SerializationException("Could not find tag '" + name + "'");
    }

    @Override
    protected ValueReader findOptional(int tag, String name) {
        if (this.isNext(-1, name)) {
            return new JsonValueReader(this.iter.next().getValue());
        }
        return null;
    }

    @Override
    public boolean isNext(int tag, String name) {
        Objects.requireNonNull(name, "name is null");
        if (this.iter.hasNext()) {
            return name.equals(this.iter.peek().getKey());
        }
        return false;
    }

    @Override
    public <T extends MessageEnum> T readEnum(int tag, String name, MessageEnumSerializer<T> factory) throws IOException {
        ValueReader r = this.find(tag, name);
        return factory.from(r.readText());
    }

    @Override
    public <K, V> Map<K, V> readMap(int tag, String name, ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        if (this.isNext(-1, name)) {
            Map.Entry<String, JsonValue> next = this.iter.next();
            return new JsonValueReader(next.getValue()).readMap(keyParser, valueParser);
        }
        return Collections.emptyMap();
    }

    @Override
    public <T extends Message> T readMessage(int tag, String name, MessageSerializer<T> parser) throws IOException {
        if (this.isNext(-1, name)) {
            Map.Entry<String, JsonValue> next = this.iter.next();
            return new JsonValueReader(next.getValue()).readMessage(parser);
        }
        return null;
    }

    public static <T> T readFromString(String value, ValueSerializer<T> parser) throws IOException {
        String ss = " { \"x\": " + value + "}";
        JsonReader reader = JsonProvider.provider().createReader(new StringReader(ss));
        JsonObject o = reader.readObject();
        JsonValue val = (JsonValue)o.get("x");
        JsonValueReader r = new JsonValueReader(val);
        return parser.read(r);
    }

    static class JsonIterator {
        Iterator<Map.Entry<String, JsonValue>> iter;
        private Map.Entry<String, JsonValue> next;
        final JsonObject o;

        JsonIterator(JsonObject o) {
            this.o = o;
            this.iter = o.entrySet().iterator();
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
            }
        }

        boolean hasNext() {
            return this.next != null;
        }

        Map.Entry<String, JsonValue> next() {
            Map.Entry<String, JsonValue> n = this.next;
            this.next = this.iter.hasNext() ? this.iter.next() : null;
            return n;
        }

        Map.Entry<String, JsonValue> peek() {
            return this.next;
        }
    }
}

