/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.protobuf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.core.com.google.protobuf.CodedOutputStream;
import net.maritimecloud.internal.message.binary.AbstractBinaryValueWriter;
import net.maritimecloud.internal.message.binary.protobuf.ProtobufMessageWriter;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;

public class ProtobufValueWriter
extends AbstractBinaryValueWriter {
    final CodedOutputStream cos;

    ProtobufValueWriter(CodedOutputStream cos) {
        this.cos = Objects.requireNonNull(cos);
    }

    public ProtobufValueWriter(OutputStream os) {
        this(CodedOutputStream.newInstance(os));
    }

    @Override
    public void flush() throws IOException {
        this.cos.flush();
    }

    @Override
    public void writeBinary(Binary binary) throws IOException {
        byte[] b = binary.toByteArray();
        this.cos.writeByteArrayNoTag(b);
    }

    @Override
    public void writeInt(Integer value) throws IOException {
        this.cos.writeSInt32NoTag(value);
    }

    @Override
    public void writeInt64(Long value) throws IOException {
        this.cos.writeSInt64NoTag(value);
    }

    @Override
    public void writeDecimal(BigDecimal value) throws IOException {
        this.writeInt(value.scale());
        this.writeBinary(Binary.copyFrom(value.unscaledValue().toByteArray()));
    }

    @Override
    public <T> void writeList(List<T> list, ValueSerializer<T> serializer) throws IOException {
        for (T t : list) {
            if (t == null) continue;
            serializer.write(t, this);
        }
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) continue;
            keySerializer.write(key, this);
            valueSerializer.write(value, this);
        }
    }

    @Override
    public <T extends Message> void writeMessage(T message, MessageSerializer<T> serializer) throws IOException {
        byte[] b = ProtobufValueWriter.writeWithMessageWriter(e -> serializer.write(message, (MessageWriter)e));
        this.writeBinary(Binary.copyFrom(b));
    }

    static byte[] writeWithValueWriter(IOEConsumer<ProtobufValueWriter> w) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream bos = CodedOutputStream.newInstance(baos);
        ProtobufValueWriter bvw = new ProtobufValueWriter(bos);
        w.consume(bvw);
        bvw.flush();
        return baos.toByteArray();
    }

    static byte[] writeWithMessageWriter(IOEConsumer<ProtobufMessageWriter> w) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufMessageWriter bmw = new ProtobufMessageWriter(baos);
        w.consume(bmw);
        bmw.flush();
        return baos.toByteArray();
    }

    static interface IOEConsumer<T> {
        public void consume(T var1) throws IOException;
    }
}

