/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.protobuf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.maritimecloud.internal.core.com.google.protobuf.CodedOutputStream;
import net.maritimecloud.internal.message.binary.AbstractBinaryMessageWriter;
import net.maritimecloud.internal.message.binary.protobuf.ProtobufValueWriter;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueSerializer;

public class ProtobufMessageWriter
extends AbstractBinaryMessageWriter {
    final CodedOutputStream cos;

    public ProtobufMessageWriter(OutputStream os) {
        this.cos = CodedOutputStream.newInstance(os);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.cos.flush();
    }

    @Override
    public void writeBoolean(int tag, String name, Boolean value) throws IOException {
        if (value != null) {
            this.cos.writeBool(tag, value);
        }
    }

    @Override
    protected void writeBinary(int tag, byte[] bin) throws IOException {
        if (bin != null) {
            this.cos.writeByteArray(tag, bin);
        }
    }

    @Override
    protected void writeInt640(int tag, long value) throws IOException {
        this.cos.writeSInt64(tag, value);
    }

    @Override
    protected <T extends Message> void writeMessage0(int tag, T message, MessageSerializer<T> serializer) throws IOException {
        byte[] bytes = ProtobufValueWriter.writeWithMessageWriter(w -> serializer.write(message, (MessageWriter)w));
        this.cos.writeByteArray(tag, bytes);
    }

    @Override
    protected void writeInt640(int tag, String name, long value) throws IOException {
        this.writeInt640(tag, value);
    }

    @Override
    protected void writeDecimal0(int tag, BigDecimal bd) throws IOException {
        byte[] bytes = ProtobufValueWriter.writeWithValueWriter(w -> w.writeDecimal(bd));
        this.cos.writeByteArray(tag, bytes);
    }

    @Override
    protected void writeInt0(int tag, int value) throws IOException {
        this.cos.writeSInt32(tag, value);
    }

    @Override
    protected <K, V> void writeMap0(int tag, Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        byte[] bytes = ProtobufValueWriter.writeWithValueWriter(w -> w.writeMap(map, keySerializer, valueSerializer));
        this.cos.writeByteArray(tag, bytes);
    }

    @Override
    protected <T> void writeSetOrList(int tag, Collection<T> col, ValueSerializer<T> serializer) throws IOException {
        byte[] bytes = ProtobufValueWriter.writeWithValueWriter(w -> w.writeList(new ArrayList(col), serializer));
        this.cos.writeByteArray(tag, bytes);
    }

    public static <T extends Message> byte[] write(T message, MessageSerializer<T> serializer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ProtobufMessageWriter bvw = new ProtobufMessageWriter(out);
        serializer.write(message, bvw);
        bvw.flush();
        return out.toByteArray();
    }
}

