/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.protobuf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.maritimecloud.internal.core.com.google.protobuf.CodedInputStream;
import net.maritimecloud.internal.core.com.google.protobuf.CodedOutputStream;
import net.maritimecloud.internal.message.AbstractMessageReader;
import net.maritimecloud.internal.message.binary.protobuf.ProtobufValueReader;
import net.maritimecloud.internal.message.binary.protobuf.ProtobufWireFormat;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.SerializationException;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.message.ValueSerializer;

public class ProtobufMessageReader
extends AbstractMessageReader {
    final Map<Integer, ValueReader> fieldValues = new ConcurrentHashMap<Integer, ValueReader>();
    final Integer[] tags;
    int tagIndex = 0;

    @Override
    public MessageFormatType getFormatType() {
        return MessageFormatType.MACHINE_READABLE;
    }

    public ProtobufMessageReader(InputStream in) throws IOException {
        this(CodedInputStream.newInstance(in));
    }

    public ProtobufMessageReader(CodedInputStream cis) throws IOException {
        block4: while (!cis.isAtEnd()) {
            int pbTag = cis.readTag();
            int tag = ProtobufWireFormat.getTagFieldNumber(pbTag);
            int wireType = ProtobufWireFormat.getTagWireType(pbTag);
            switch (wireType) {
                case 0: {
                    this.fieldValues.put(tag, new ProtobufValueReader(cis.readSInt64()));
                    continue block4;
                }
                case 2: {
                    this.fieldValues.put(tag, new ProtobufValueReader(CodedInputStream.newInstance(this.readByteArray(cis))));
                    continue block4;
                }
            }
            throw new SerializationException("Invalid protobuf wire type " + wireType);
        }
        this.tags = (Integer[])this.fieldValues.keySet().stream().toArray(Integer[]::new);
    }

    private byte[] readByteArray(CodedInputStream cis) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CodedOutputStream cout = CodedOutputStream.newInstance(bout);
        cout.writeByteArrayNoTag(cis.readByteArray());
        cout.flush();
        return bout.toByteArray();
    }

    @Override
    public boolean isNext(int tag, String name) {
        return this.tagIndex <= this.tags.length - 1 && this.tags[this.tagIndex].equals(tag);
    }

    @Override
    public <T extends MessageEnum> T readEnum(int tag, String name, MessageEnumSerializer<T> factory) throws IOException {
        int enumValue = this.readInt(tag, name);
        return factory.from(enumValue);
    }

    @Override
    public <K, V> Map<K, V> readMap(int tag, String name, ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? Collections.emptyMap() : r.readMap(keyParser, valueParser);
    }

    @Override
    public <T extends Message> T readMessage(int tag, String name, MessageSerializer<T> parser) throws IOException {
        ValueReader valueReader = this.findOptional(tag, name);
        return valueReader == null ? null : (T)valueReader.readMessage(parser);
    }

    @Override
    protected ValueReader find(int tag, String name) throws SerializationException {
        ValueReader valueReader = this.findOptional(tag, name);
        if (valueReader == null) {
            throw new SerializationException("Could not find tag " + tag);
        }
        return valueReader;
    }

    @Override
    protected ValueReader findOptional(int tag, String name) {
        if (this.isNext(tag, name)) {
            ++this.tagIndex;
            return this.fieldValues.get(tag);
        }
        return null;
    }

    public static <T extends Message> T read(byte[] message, MessageSerializer<T> serializer) throws IOException {
        CodedInputStream bin = CodedInputStream.newInstance(message);
        ProtobufMessageReader reader = new ProtobufMessageReader(bin);
        return serializer.read(reader);
    }
}

