/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.message.binary.AbstractBinaryValueReader;
import net.maritimecloud.internal.message.binary.compact.BinaryInputStream;
import net.maritimecloud.internal.message.binary.compact.BinaryMessageReader;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;

public class FlexibleBinaryValueReader
extends AbstractBinaryValueReader {
    private final int wireType;
    private final BinaryInputStream bis;

    FlexibleBinaryValueReader(int wireType, BinaryInputStream bis) {
        this.wireType = wireType;
        this.bis = Objects.requireNonNull(bis);
    }

    @Override
    public Integer readInt() throws IOException {
        long l = this.readInt64();
        return (int)l;
    }

    @Override
    public Long readInt64() throws IOException {
        switch (this.wireType) {
            case 0: {
                return 0L;
            }
            case 1: {
                return 1L;
            }
            case 2: {
                return 2L;
            }
            case 3: {
                return -1L;
            }
            case 4: {
                long b = this.bis.read08Bits();
                return b;
            }
            case 5: {
                long b = this.bis.read16Bits();
                return b;
            }
            case 6: {
                long b = this.bis.read32Bits();
                return b;
            }
            case 9: {
                return 1L;
            }
            case 8: {
                return 1L;
            }
        }
        throw new IOException("Illegal wireType");
    }

    @Override
    public Binary readBinary() throws IOException {
        switch (this.wireType) {
            case 0: {
                return Binary.copyFrom(0);
            }
            case 1: {
                return Binary.copyFrom(1);
            }
            case 2: {
                return Binary.copyFrom(2);
            }
            case 3: {
                return Binary.copyFrom(-1);
            }
            case 4: {
                return Binary.copyFrom(this.bis.read(1));
            }
            case 5: {
                return Binary.copyFrom(this.bis.read(2));
            }
            case 6: {
                return Binary.copyFrom(this.bis.read(4));
            }
            case 7: {
                return Binary.copyFrom(this.bis.read(8));
            }
            case 10: {
                int numberOfBytes = this.bis.readVarint32();
                return Binary.copyFrom(this.bis.read(numberOfBytes));
            }
        }
        throw new IOException("Illegal wireType");
    }

    @Override
    public <T extends Message> T readMessage(MessageSerializer<T> parser) throws IOException {
        Binary bin = this.readBinary();
        BinaryMessageReader bmr = new BinaryMessageReader(new BinaryInputStream(bin));
        return parser.read(bmr);
    }

    @Override
    public <T> List<T> readList(ValueSerializer<T> parser) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public <K, V> Map<K, V> readMap(ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        return Collections.emptyMap();
    }
}

