/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.message.binary.AbstractBinaryValueWriter;
import net.maritimecloud.internal.message.binary.BinaryUtils;
import net.maritimecloud.internal.message.binary.compact.BinaryOutputStream;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.message.ValueWriter;
import net.maritimecloud.util.Binary;

public class BinaryValueWriter
extends AbstractBinaryValueWriter {
    final BinaryOutputStream bos;

    BinaryValueWriter(BinaryOutputStream bos) {
        this.bos = Objects.requireNonNull(bos);
    }

    @Override
    public void writeBinary(Binary binary) throws IOException {
        byte[] b = binary.toByteArray();
        this.bos.writeRawVarint32(b.length);
        this.bos.writeBytes(b);
    }

    @Override
    public void writeInt(Integer value) throws IOException {
        this.bos.writeRawVarint32(BinaryUtils.encodeZigZag32(value));
    }

    @Override
    public void writeInt64(Long value) throws IOException {
        this.bos.writeRawVarint64(BinaryUtils.encodeZigZag64(value));
    }

    @Override
    public <T> void writeList(List<T> list, ValueSerializer<T> serializer) throws IOException {
        byte[] b = BinaryValueWriter.writeWithWriter(e -> {
            for (Object t : list) {
                if (t == null) continue;
                serializer.write((Object)t, (ValueWriter)e);
            }
        });
        this.writeBinary(Binary.copyFrom(b));
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        byte[] b = BinaryValueWriter.writeWithWriter(e -> {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                keySerializer.write(key, (ValueWriter)e);
                valueSerializer.write(value, (ValueWriter)e);
            }
        });
        this.writeBinary(Binary.copyFrom(b));
    }

    @Override
    public <T extends Message> void writeMessage(T message, MessageSerializer<T> serializer) throws IOException {
        byte[] b = BinaryValueWriter.writeWithWriter(e -> serializer.write(message, (ValueWriter)e));
        this.writeBinary(Binary.copyFrom(b));
    }

    static byte[] writeWithWriter(IOEConsumer<BinaryValueWriter> w) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream(baos);
        BinaryValueWriter bvw = new BinaryValueWriter(bos);
        w.consume(bvw);
        bvw.flush();
        return baos.toByteArray();
    }

    static interface IOEConsumer<T> {
        public void consume(T var1) throws IOException;
    }
}

