/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import net.maritimecloud.internal.message.AbstractMessageReader;
import net.maritimecloud.internal.message.binary.compact.BinaryInputStream;
import net.maritimecloud.internal.message.binary.compact.FlexibleBinaryValueReader;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.SerializationException;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;

public class BinaryMessageReader
extends AbstractMessageReader {
    final BinaryInputStream bis;

    @Override
    public MessageFormatType getFormatType() {
        return MessageFormatType.MACHINE_READABLE;
    }

    public BinaryMessageReader(BinaryInputStream bis) {
        this.bis = bis;
    }

    @Override
    public boolean isNext(int tag, String name) throws IOException {
        return tag == this.bis.getFieldId();
    }

    @Override
    public <T extends MessageEnum> T readEnum(int tag, String name, MessageEnumSerializer<T> factory) throws IOException {
        int enumValue = this.readInt(tag, name);
        return factory.from(enumValue);
    }

    @Override
    public <K, V> Map<K, V> readMap(int tag, String name, ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        return null;
    }

    @Override
    public <T extends Message> T readMessage(int tag, String name, MessageSerializer<T> parser) throws IOException {
        Binary bin = this.readBinary(tag, name, Binary.EMPTY);
        if (bin != null) {
            BinaryMessageReader bmr = new BinaryMessageReader(new BinaryInputStream(bin));
            return parser.read(bmr);
        }
        return null;
    }

    @Override
    protected ValueReader find(int tag, String name) throws SerializationException {
        return null;
    }

    @Override
    protected ValueReader findOptional(int tag, String name) throws IOException {
        if (this.isNext(tag, name)) {
            int wireType = this.bis.getWireType();
            return new FlexibleBinaryValueReader(wireType, this.bis);
        }
        return null;
    }

    public static <T extends Message> T read(byte[] message, MessageSerializer<T> serializer) throws IOException {
        ByteArrayInputStream baos = new ByteArrayInputStream(message);
        BinaryInputStream bos = new BinaryInputStream(baos);
        BinaryMessageReader bvw = new BinaryMessageReader(bos);
        return serializer.read(bvw);
    }
}

