/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.maritimecloud.internal.message.binary.ReaderUtils;
import net.maritimecloud.util.Binary;

public class BinaryUtils {
    public static int computeVarInt32(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static Binary encodeBigDecimal(BigDecimal value) {
        byte[] b = BinaryUtils.encodeVarInt32(value.scale());
        Binary bin = Binary.copyFrom(b);
        return bin.concat(BinaryUtils.encodeBigInteger(value.unscaledValue()));
    }

    public static Binary encodeBigInteger(BigInteger bi) {
        return Binary.copyFrom(bi.toByteArray());
    }

    public static BigDecimal decodeBigDecimal(Binary b) throws IOException {
        InputStream is = b.newInput();
        int scale = ReaderUtils.readRawVarint32(is);
        Binary bin = Binary.readFrom(is);
        BigInteger unscaled = new BigInteger(bin.toByteArray());
        return new BigDecimal(unscaled, scale);
    }

    public static BigInteger decodeBigInteger(Binary b) {
        return new BigInteger(b.toByteArray());
    }

    public static byte[] encodeVarInt32(int value) {
        int size = BinaryUtils.computeVarInt32(value);
        byte[] b = new byte[size];
        int i = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                b[i] = (byte)value;
                return b;
            }
            b[i] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }
}

