/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.maritimecloud.internal.message.binary.BinaryUtils;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class AbstractBinaryValueReader
implements ValueReader {
    @Override
    public final Boolean readBoolean() throws IOException {
        Integer i = this.readInt();
        return i != 0;
    }

    @Override
    public final Double readDouble() throws IOException {
        long l = this.readInt64();
        return Double.longBitsToDouble(l);
    }

    @Override
    public final <T extends MessageEnum> T readEnum(MessageEnumSerializer<T> factory) throws IOException {
        Integer i = this.readInt();
        return factory.from(i);
    }

    @Override
    public final Float readFloat() throws IOException {
        int i = this.readInt();
        return Float.valueOf(Float.intBitsToFloat(i));
    }

    @Override
    public final MessageFormatType getFormatType() {
        return MessageFormatType.MACHINE_READABLE;
    }

    @Override
    public final Position readPosition() throws IOException {
        return Position.fromBinary(this.readBinary());
    }

    @Override
    public final PositionTime readPositionTime() throws IOException {
        return PositionTime.fromBinary(this.readBinary());
    }

    @Override
    public final String readText() throws IOException {
        return this.readBinary().toStringUtf8();
    }

    @Override
    public BigInteger readVarInt() throws IOException {
        Binary b = this.readBinary();
        return BinaryUtils.decodeBigInteger(b);
    }

    @Override
    public BigDecimal readDecimal() throws IOException {
        Binary b = this.readBinary();
        return BinaryUtils.decodeBigDecimal(b);
    }
}

