/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maritimecloud.internal.message.MessageHelper;
import net.maritimecloud.internal.message.binary.BinaryUtils;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class AbstractBinaryMessageWriter
implements MessageWriter {
    @Override
    public final MessageFormatType getFormatType() {
        return MessageFormatType.MACHINE_READABLE;
    }

    protected abstract void writeBinary(int var1, byte[] var2) throws IOException;

    @Override
    public void writeBinary(int tag, String name, Binary binary) throws IOException {
        if (binary != null && !binary.isEmpty()) {
            this.writeBinary(tag, binary.toByteArray());
        }
    }

    @Override
    public void writeDecimal(int tag, String name, BigDecimal value) throws IOException {
        if (value != null) {
            this.writeDecimal0(tag, value);
        }
    }

    protected abstract void writeDecimal0(int var1, BigDecimal var2) throws IOException;

    @Override
    public final void writeDouble(int tag, String name, Double value) throws IOException {
        if (value != null) {
            this.writeDouble0(tag, MessageHelper.checkDouble(value));
        }
    }

    protected void writeDouble0(int tag, double value) throws IOException {
        long val = Double.doubleToLongBits(MessageHelper.checkDouble(value));
        this.writeInt640(tag, val);
    }

    @Override
    public final void writeEnum(int tag, String name, MessageEnum serializable) throws IOException {
        if (serializable != null) {
            this.writeInt0(tag, serializable.getValue());
        }
    }

    @Override
    public final void writeFloat(int tag, String name, Float value) throws IOException {
        if (value != null) {
            this.writeFloat0(tag, MessageHelper.checkFloat(value.floatValue()));
        }
    }

    protected void writeFloat0(int tag, float value) throws IOException {
        int val = Float.floatToIntBits(MessageHelper.checkFloat(value));
        this.writeInt0(tag, val);
    }

    @Override
    public void writeInt(int tag, String name, Integer value) throws IOException {
        if (value != null) {
            this.writeInt0(tag, value);
        }
    }

    protected abstract void writeInt0(int var1, int var2) throws IOException;

    @Override
    public final void writeInt64(int tag, String name, Long value) throws IOException {
        if (value != null) {
            this.writeInt640(tag, value);
        }
    }

    protected abstract void writeInt640(int var1, long var2) throws IOException;

    protected abstract void writeInt640(int var1, String var2, long var3) throws IOException;

    @Override
    public final <T> void writeList(int tag, String name, List<T> list, ValueSerializer<T> serializer) throws IOException {
        if (list != null && list.size() > 0) {
            this.writeSetOrList(tag, list, serializer);
        }
    }

    @Override
    public <K, V> void writeMap(int tag, String name, Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        if (map != null && map.size() > 0) {
            this.writeMap0(tag, map, keySerializer, valueSerializer);
        }
    }

    protected abstract <K, V> void writeMap0(int var1, Map<K, V> var2, ValueSerializer<K> var3, ValueSerializer<V> var4) throws IOException;

    @Override
    public final <T extends Message> void writeMessage(int tag, String name, T message, MessageSerializer<T> serializer) throws IOException {
        if (message != null) {
            this.writeMessage0(tag, message, serializer);
        }
    }

    protected abstract <T extends Message> void writeMessage0(int var1, T var2, MessageSerializer<T> var3) throws IOException;

    @Override
    public void writePosition(int tag, String name, Position value) throws IOException {
        if (value != null) {
            this.writeBinary(tag, name, value.toBinary());
        }
    }

    @Override
    public void writePositionTime(int tag, String name, PositionTime value) throws IOException {
        if (value != null) {
            this.writeBinary(tag, name, value.toBinary());
        }
    }

    @Override
    public final <T> void writeSet(int tag, String name, Set<T> set, ValueSerializer<T> serializer) throws IOException {
        if (set != null && set.size() > 0) {
            this.writeSetOrList(tag, set, serializer);
        }
    }

    protected abstract <T> void writeSetOrList(int var1, Collection<T> var2, ValueSerializer<T> var3) throws IOException;

    @Override
    public void writeText(int tag, String name, String value) throws IOException {
        if (value != null) {
            byte[] text = value.getBytes("UTF-8");
            this.writeBinary(tag, text);
        }
    }

    @Override
    public final void writeTimestamp(int tag, String name, Timestamp value) throws IOException {
        if (value != null) {
            this.writeInt640(tag, name, value.getTime());
        }
    }

    @Override
    public void writeVarInt(int tag, String name, BigInteger value) throws IOException {
        if (value != null) {
            if (value.bitLength() < 64) {
                this.writeInt640(tag, value.longValueExact());
            } else {
                this.writeBinary(tag, name, BinaryUtils.encodeBigInteger(value));
            }
        }
    }
}

