/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maritimecloud.internal.message.TaggableValueWriter;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public class TaggableMessageWriter
implements MessageWriter {
    final TaggableValueWriter w;

    public TaggableMessageWriter(TaggableValueWriter w) {
        this.w = w;
    }

    @Override
    public void close() throws IOException {
        this.w.close();
    }

    @Override
    public void flush() throws IOException {
        this.w.flush();
    }

    @Override
    public MessageFormatType getFormatType() {
        return MessageFormatType.HUMAN_READABLE;
    }

    @Override
    public void writeBinary(int tag, String name, Binary binary) throws IOException {
        if (binary != null) {
            this.w.writeTag(tag, name).writeBinary(binary);
        }
    }

    @Override
    public void writeBoolean(int tag, String name, Boolean value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeBoolean(value);
        }
    }

    @Override
    public void writeDecimal(int tag, String name, BigDecimal value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeDecimal(value);
        }
    }

    @Override
    public void writeDouble(int tag, String name, Double value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeDouble(value);
        }
    }

    @Override
    public void writeEnum(int tag, String name, MessageEnum value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeEnum(value);
        }
    }

    @Override
    public void writeFloat(int tag, String name, Float value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeFloat(value);
        }
    }

    @Override
    public void writeInt(int tag, String name, Integer value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeInt(value);
        }
    }

    @Override
    public void writeInt64(int tag, String name, Long value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeInt64(value);
        }
    }

    @Override
    public <T> void writeList(int tag, String name, List<T> list, ValueSerializer<T> serializer) throws IOException {
        if (list != null && list.size() > 0) {
            this.w.writeTag(tag, name).writeList(list, serializer);
        }
    }

    @Override
    public <K, V> void writeMap(int tag, String name, Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        if (map != null && map.size() > 0) {
            this.w.writeTag(tag, name).writeMap(map, keySerializer, valueSerializer);
        }
    }

    @Override
    public <T extends Message> void writeMessage(int tag, String name, T message, MessageSerializer<T> serializer) throws IOException {
        if (message != null) {
            this.w.writeTag(tag, name).writeMessage(message, serializer);
        }
    }

    @Override
    public void writePosition(int tag, String name, Position value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writePosition(value);
        }
    }

    @Override
    public void writePositionTime(int tag, String name, PositionTime value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writePositionTime(value);
        }
    }

    @Override
    public <T> void writeSet(int tag, String name, Set<T> value, ValueSerializer<T> serializer) throws IOException {
        if (value != null && value.size() > 0) {
            this.w.writeTag(tag, name).writeSet(value, serializer);
        }
    }

    @Override
    public void writeText(int tag, String name, String value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeText(value);
        }
    }

    @Override
    public void writeTimestamp(int tag, String name, Timestamp value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeTimestamp(value);
        }
    }

    @Override
    public void writeVarInt(int tag, String name, BigInteger value) throws IOException {
        if (value != null) {
            this.w.writeTag(tag, name).writeVarInt(value);
        }
    }
}

