/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class AbstractMessageReader
implements MessageReader {
    protected abstract ValueReader find(int var1, String var2) throws IOException;

    protected abstract ValueReader findOptional(int var1, String var2) throws IOException;

    @Override
    public Binary readBinary(int tag, String name, Binary defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readBinary();
    }

    @Override
    public Boolean readBoolean(int tag, String name, Boolean defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readBoolean();
    }

    @Override
    public BigDecimal readDecimal(int tag, String name) throws IOException {
        return this.find(tag, name).readDecimal();
    }

    @Override
    public BigDecimal readDecimal(int tag, String name, BigDecimal defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readDecimal();
    }

    @Override
    public double readDouble(int tag, String name) throws IOException {
        return this.find(tag, name).readDouble();
    }

    @Override
    public Double readDouble(int tag, String name, Double defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readDouble();
    }

    @Override
    public float readFloat(int tag, String name) throws IOException {
        return this.find(tag, name).readFloat().floatValue();
    }

    @Override
    public Float readFloat(int tag, String name, Float defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readFloat();
    }

    @Override
    public int readInt(int tag, String name) throws IOException {
        return this.find(tag, name).readInt();
    }

    @Override
    public Integer readInt(int tag, String name, Integer defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readInt();
    }

    @Override
    public long readInt64(int tag, String name) throws IOException {
        return this.find(tag, name).readInt64();
    }

    @Override
    public Long readInt64(int tag, String name, Long defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readInt64();
    }

    @Override
    public <T> List<T> readList(int tag, String name, ValueSerializer<T> parser) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? Collections.emptyList() : r.readList(parser);
    }

    @Override
    public Position readPosition(int tag, String name) throws IOException {
        return this.find(tag, name).readPosition();
    }

    @Override
    public Position readPosition(int tag, String name, Position defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readPosition();
    }

    @Override
    public PositionTime readPositionTime(int tag, String name) throws IOException {
        return this.find(tag, name).readPositionTime();
    }

    @Override
    public PositionTime readPositionTime(int tag, String name, PositionTime defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readPositionTime();
    }

    @Override
    public <T> Set<T> readSet(int tag, String name, ValueSerializer<T> parser) throws IOException {
        return new HashSet<T>(this.readList(tag, name, parser));
    }

    @Override
    public String readText(int tag, String name, String defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readText();
    }

    @Override
    public Timestamp readTimestamp(int tag, String name) throws IOException {
        return this.find(tag, name).readTimestamp();
    }

    @Override
    public Timestamp readTimestamp(int tag, String name, Timestamp defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readTimestamp();
    }

    @Override
    public BigInteger readVarInt(int tag, String name) throws IOException {
        return this.find(tag, name).readVarInt();
    }

    @Override
    public BigInteger readVarInt(int tag, String name, BigInteger defaultValue) throws IOException {
        ValueReader r = this.findOptional(tag, name);
        return r == null ? defaultValue : r.readVarInt();
    }
}

