/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.core.id;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import net.maritimecloud.core.id.MmsiId;
import net.maritimecloud.core.id.TestId;

public abstract class MaritimeId
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String scheme;

    protected MaritimeId(String scheme) {
        this.scheme = Objects.requireNonNull(scheme);
    }

    public static MaritimeId create(String id) {
        URI uri;
        Objects.requireNonNull(id, "id is null");
        try {
            uri = new URI(id);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Illegal id, must start with 'some_scheme://', was " + id);
        }
        if (uri.getScheme().equals("mmsi")) {
            int mmsi = Integer.parseInt(uri.getSchemeSpecificPart());
            return new MmsiId(mmsi);
        }
        if (uri.getScheme().equals("test")) {
            return new TestId(uri.getSchemeSpecificPart());
        }
        throw new IllegalArgumentException("Unknown scheme " + uri.getScheme());
    }

    public abstract String getId();

    public int getIdAsInt() {
        return Integer.parseInt(this.getId());
    }
}

