/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.Map;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.slf4j.MDC;

public class MDCContextMap
implements CleanableThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);

    @Override
    public void put(String key, String value) {
        MDC.put(key, value);
    }

    @Override
    public void putAll(Map<String, String> m2) {
        for (Map.Entry<String, String> entry : m2.entrySet()) {
            MDC.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String get(String key) {
        return MDC.get(key);
    }

    @Override
    public void remove(String key) {
        MDC.remove(key);
    }

    @Override
    public void removeAll(Iterable<String> keys2) {
        for (String key : keys2) {
            MDC.remove(key);
        }
    }

    @Override
    public void clear() {
        MDC.clear();
    }

    @Override
    public boolean containsKey(String key) {
        Map<String, String> map2 = MDC.getCopyOfContextMap();
        return map2 != null && map2.containsKey(key);
    }

    @Override
    public Map<String, String> getCopy() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public boolean isEmpty() {
        Map<String, String> map2 = MDC.getCopyOfContextMap();
        return map2 == null || map2.isEmpty();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        Map<String, String> copy2 = this.getCopy();
        if (copy2.isEmpty()) {
            return EMPTY_CONTEXT_DATA;
        }
        SortedArrayStringMap result2 = new SortedArrayStringMap();
        for (Map.Entry<String, String> entry : copy2.entrySet()) {
            result2.putValue(entry.getKey(), entry.getValue());
        }
        return result2;
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
    }
}

