/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.HtmlTextRenderer;
import org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.core.util.ArrayUtils;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilderFormattable;

@Plugin(name="MessagePatternConverter", category="Converter")
@ConverterKeys(value={"m", "msg", "message"})
@PerformanceSensitive(value={"allocation"})
public final class MessagePatternConverter
extends LogEventPatternConverter {
    private static final String NOLOOKUPS = "nolookups";
    private final String[] formats;
    private final Configuration config;
    private final TextRenderer textRenderer;
    private final boolean noLookups;

    private MessagePatternConverter(Configuration config2, String[] options2) {
        super("Message", "message");
        this.formats = options2;
        this.config = config2;
        int noLookupsIdx = this.loadNoLookups(options2);
        this.noLookups = Constants.FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS || noLookupsIdx >= 0;
        this.textRenderer = this.loadMessageRenderer(noLookupsIdx >= 0 ? ArrayUtils.remove(options2, noLookupsIdx) : options2);
    }

    private int loadNoLookups(String[] options2) {
        if (options2 != null) {
            for (int i = 0; i < options2.length; ++i) {
                String option = options2[i];
                if (!NOLOOKUPS.equalsIgnoreCase(option)) continue;
                return i;
            }
        }
        return -1;
    }

    private TextRenderer loadMessageRenderer(String[] options2) {
        if (options2 != null) {
            for (String option : options2) {
                switch (option.toUpperCase(Locale.ROOT)) {
                    case "ANSI": {
                        if (Loader.isJansiAvailable()) {
                            return new JAnsiTextRenderer(options2, JAnsiTextRenderer.DefaultMessageStyleMap);
                        }
                        StatusLogger.getLogger().warn("You requested ANSI message rendering but JANSI is not on the classpath.");
                        return null;
                    }
                    case "HTML": {
                        return new HtmlTextRenderer(options2);
                    }
                }
            }
        }
        return null;
    }

    public static MessagePatternConverter newInstance(Configuration config2, String[] options2) {
        return new MessagePatternConverter(config2, options2);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        Message msg = event.getMessage();
        if (msg instanceof StringBuilderFormattable) {
            boolean doRender = this.textRenderer != null;
            StringBuilder workingBuilder = doRender ? new StringBuilder(80) : toAppendTo;
            int offset = workingBuilder.length();
            if (msg instanceof MultiFormatStringBuilderFormattable) {
                ((MultiFormatStringBuilderFormattable)msg).formatTo(this.formats, workingBuilder);
            } else {
                ((StringBuilderFormattable)((Object)msg)).formatTo(workingBuilder);
            }
            if (this.config != null && !this.noLookups) {
                for (int i = offset; i < workingBuilder.length() - 1; ++i) {
                    if (workingBuilder.charAt(i) != '$' || workingBuilder.charAt(i + 1) != '{') continue;
                    String value = workingBuilder.substring(offset, workingBuilder.length());
                    workingBuilder.setLength(offset);
                    workingBuilder.append(this.config.getStrSubstitutor().replace(event, value));
                }
            }
            if (doRender) {
                this.textRenderer.render(workingBuilder, toAppendTo);
            }
            return;
        }
        if (msg != null) {
            String result2 = msg instanceof MultiformatMessage ? ((MultiformatMessage)msg).getFormattedMessage(this.formats) : msg.getFormattedMessage();
            if (result2 != null) {
                toAppendTo.append(this.config != null && result2.contains("${") ? this.config.getStrSubstitutor().replace(event, result2) : result2);
            } else {
                toAppendTo.append("null");
            }
        }
    }
}

