/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.streams.InputKt;
import io.ktor.utils.io.streams.OutputKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.utils.MiraiFile;
import net.mamoe.mirai.utils.MiraiFileKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\b\u00a8\u0006%"}, d2={"Lnet/mamoe/mirai/utils/JvmFileAsMiraiFile;", "Lnet/mamoe/mirai/utils/MiraiFile;", "jvmFile", "Ljava/io/File;", "(Ljava/io/File;)V", "absolutePath", "", "getAbsolutePath", "()Ljava/lang/String;", "isDirectory", "", "()Z", "isFile", "getJvmFile$mirai_core_utils", "()Ljava/io/File;", "length", "", "getLength", "()J", "name", "getName", "parent", "getParent", "()Lnet/mamoe/mirai/utils/MiraiFile;", "path", "getPath", "createNewFile", "delete", "exists", "input", "Lio/ktor/utils/io/core/Input;", "mkdir", "mkdirs", "output", "Lio/ktor/utils/io/core/Output;", "resolve", "file", "mirai-core-utils"})
public final class JvmFileAsMiraiFile
implements MiraiFile {
    @NotNull
    private final File jvmFile;

    public JvmFileAsMiraiFile(@NotNull File jvmFile) {
        Intrinsics.checkNotNullParameter(jvmFile, "jvmFile");
        this.jvmFile = jvmFile;
    }

    @NotNull
    public final File getJvmFile$mirai_core_utils() {
        return this.jvmFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.jvmFile.getName();
        Intrinsics.checkNotNullExpressionValue(string, "jvmFile.name");
        return string;
    }

    @Override
    @Nullable
    public MiraiFile getParent() {
        File file = this.jvmFile.getParentFile();
        return file != null ? MiraiFileKt.asMiraiFile(file) : null;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.jvmFile.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "jvmFile.path");
        return string;
    }

    @Override
    @NotNull
    public String getAbsolutePath() {
        String string = this.jvmFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "jvmFile.absolutePath");
        return string;
    }

    @Override
    public long getLength() {
        return this.jvmFile.length();
    }

    @Override
    public boolean isFile() {
        return this.jvmFile.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.jvmFile.isDirectory();
    }

    @Override
    public boolean exists() {
        return this.jvmFile.exists();
    }

    @Override
    @NotNull
    public MiraiFile resolve(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return MiraiFileKt.asMiraiFile(FilesKt.resolve(this.jvmFile, path));
    }

    @Override
    @NotNull
    public MiraiFile resolve(@NotNull MiraiFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return MiraiFileKt.asMiraiFile(FilesKt.resolve(this.jvmFile, file.getAbsolutePath()));
    }

    @Override
    public boolean createNewFile() {
        return this.jvmFile.createNewFile();
    }

    @Override
    public boolean delete() {
        return this.jvmFile.delete();
    }

    @Override
    public boolean mkdir() {
        return this.jvmFile.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.jvmFile.mkdirs();
    }

    @Override
    @NotNull
    public Input input() {
        return InputKt.asInput$default(new FileInputStream(this.jvmFile), null, 1, null);
    }

    @Override
    @NotNull
    public Output output() {
        return OutputKt.asOutput(new FileOutputStream(this.jvmFile));
    }
}

