/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieDateParser;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u0001H\u0005H\u0002\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lio/ktor/http/CookieDateParser;", "", "()V", "checkFieldNotNull", "", "T", "source", "", "name", "field", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "checkRequirement", "requirement", "", "msg", "Lkotlin/Function0;", "parse", "Lio/ktor/util/date/GMTDate;", "ktor-http"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source, String name, T field) {
        if (field == null) {
            throw new InvalidCookieDateException(source, "Could not find " + name);
        }
    }

    private final void checkRequirement(String source, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw new InvalidCookieDateException(source, msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        StringLexer lexer = new StringLexer(source);
        CookieDateBuilder builder = new CookieDateBuilder();
        lexer.acceptWhile(parse.1.INSTANCE);
        while (lexer.getHasRemaining()) {
            String token2;
            if (!lexer.test(parse.2.INSTANCE)) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$parse_u24lambda_u2d0 = this_$iv;
            boolean bl = false;
            $this$parse_u24lambda_u2d0.acceptWhile(parse.token.1.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(this_$iv.getSource().substring(start$iv, this_$iv.getIndex()), "this as java.lang.String\u2026ing(startIndex, endIndex)");
            CookieUtilsKt.handleToken(builder, token2);
            lexer.acceptWhile(parse.3.INSTANCE);
        }
        Object object = builder.getYear();
        Object object2 = new IntRange(70, 99);
        if (object != null && ((IntRange)object2).contains((Integer)object)) {
            Integer n = builder.getYear();
            Intrinsics.checkNotNull(n);
            builder.setYear(n + 1900);
        } else {
            object2 = new IntRange(0, 69);
            if (object != null && ((IntRange)object2).contains((Integer)object)) {
                Integer n = builder.getYear();
                Intrinsics.checkNotNull(n);
                builder.setYear(n + 2000);
            }
        }
        this.checkFieldNotNull(source, "day-of-month", builder.getDayOfMonth());
        this.checkFieldNotNull(source, "month", builder.getMonth());
        this.checkFieldNotNull(source, "year", builder.getYear());
        this.checkFieldNotNull(source, "time", builder.getHours());
        this.checkFieldNotNull(source, "time", builder.getMinutes());
        this.checkFieldNotNull(source, "time", builder.getSeconds());
        object = new IntRange(1, 31);
        object2 = builder.getDayOfMonth();
        this.checkRequirement(source, object2 != null && ((IntRange)object).contains((Integer)object2), parse.4.INSTANCE);
        Integer n = builder.getYear();
        Intrinsics.checkNotNull(n);
        this.checkRequirement(source, n >= 1601, parse.5.INSTANCE);
        Integer n2 = builder.getHours();
        Intrinsics.checkNotNull(n2);
        this.checkRequirement(source, n2 <= 23, parse.6.INSTANCE);
        Integer n3 = builder.getMinutes();
        Intrinsics.checkNotNull(n3);
        this.checkRequirement(source, n3 <= 59, parse.7.INSTANCE);
        Integer n4 = builder.getSeconds();
        Intrinsics.checkNotNull(n4);
        this.checkRequirement(source, n4 <= 59, parse.8.INSTANCE);
        return builder.build();
    }
}

