/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.DateUtilsKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cJ\u0014\u0010\u001d\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cJ\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u001a\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c*\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/ktor/http/content/LastModifiedVersion;", "Lio/ktor/http/content/Version;", "lastModified", "Ljava/util/Date;", "(Ljava/util/Date;)V", "Lio/ktor/util/date/GMTDate;", "(Lio/ktor/util/date/GMTDate;)V", "getLastModified", "()Lio/ktor/util/date/GMTDate;", "truncatedModificationDate", "appendHeadersTo", "", "builder", "Lio/ktor/http/HeadersBuilder;", "check", "Lio/ktor/http/content/VersionCheckResult;", "requestHeaders", "Lio/ktor/http/Headers;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "ifModifiedSince", "dates", "", "ifUnmodifiedSince", "toString", "", "parseDates", "ktor-http"})
public final class LastModifiedVersion
implements Version {
    private final GMTDate truncatedModificationDate;
    @NotNull
    private final GMTDate lastModified;

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders2) {
        List<Object> list;
        List<Object> dates;
        boolean bl;
        boolean bl2;
        List<Object> list2;
        Intrinsics.checkNotNullParameter(requestHeaders2, "requestHeaders");
        List<Object> list3 = requestHeaders2.getAll(HttpHeaders.INSTANCE.getIfModifiedSince());
        if (list3 != null && (list3 = this.parseDates(list3)) != null) {
            list2 = list3;
            bl2 = false;
            bl = false;
            dates = list2;
            boolean bl3 = false;
            if (!this.ifModifiedSince(dates)) {
                return VersionCheckResult.NOT_MODIFIED;
            }
        }
        if ((list = requestHeaders2.getAll(HttpHeaders.INSTANCE.getIfUnmodifiedSince())) != null && (list = this.parseDates(list)) != null) {
            list2 = list;
            bl2 = false;
            bl = false;
            dates = list2;
            boolean bl4 = false;
            if (!this.ifUnmodifiedSince(dates)) {
                return VersionCheckResult.PRECONDITION_FAILED;
            }
        }
        return VersionCheckResult.OK;
    }

    public final boolean ifModifiedSince(@NotNull List<GMTDate> dates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(dates, "dates");
            Iterable $this$any$iv = dates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GMTDate it = (GMTDate)element$iv;
                    boolean bl2 = false;
                    if (!(this.truncatedModificationDate.compareTo(it) > 0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean ifUnmodifiedSince(@NotNull List<GMTDate> dates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(dates, "dates");
            Iterable $this$all$iv = dates;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GMTDate it = (GMTDate)element$iv;
                    boolean bl2 = false;
                    if (this.truncatedModificationDate.compareTo(it) <= 0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.set(HttpHeaders.INSTANCE.getLastModified(), DateUtilsKt.toHttpDate(this.lastModified));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GMTDate> parseDates(List<String> $this$parseDates) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$parseDates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank(charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GMTDate gMTDate;
            GMTDate gMTDate2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            try {
                gMTDate2 = DateUtilsKt.fromHttpToGmtDate(it);
            }
            catch (Throwable _) {
                gMTDate2 = null;
            }
            if (gMTDate2 == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            GMTDate it$iv$iv = gMTDate;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl7 = false;
        List it = list;
        boolean bl8 = false;
        Collection collection = it;
        boolean bl9 = false;
        return !collection.isEmpty() ? list : null;
    }

    @NotNull
    public final GMTDate getLastModified() {
        return this.lastModified;
    }

    public LastModifiedVersion(@NotNull GMTDate lastModified) {
        Intrinsics.checkNotNullParameter(lastModified, "lastModified");
        this.lastModified = lastModified;
        this.truncatedModificationDate = DateKt.truncateToSeconds(this.lastModified);
    }

    public LastModifiedVersion(@NotNull Date lastModified) {
        Intrinsics.checkNotNullParameter(lastModified, "lastModified");
        this(DateJvmKt.GMTDate(lastModified.getTime()));
    }

    @NotNull
    public final GMTDate component1() {
        return this.lastModified;
    }

    @NotNull
    public final LastModifiedVersion copy(@NotNull GMTDate lastModified) {
        Intrinsics.checkNotNullParameter(lastModified, "lastModified");
        return new LastModifiedVersion(lastModified);
    }

    public static /* synthetic */ LastModifiedVersion copy$default(LastModifiedVersion lastModifiedVersion, GMTDate gMTDate, int n, Object object) {
        if ((n & 1) != 0) {
            gMTDate = lastModifiedVersion.lastModified;
        }
        return lastModifiedVersion.copy(gMTDate);
    }

    @NotNull
    public String toString() {
        return "LastModifiedVersion(lastModified=" + this.lastModified + ")";
    }

    public int hashCode() {
        GMTDate gMTDate = this.lastModified;
        return gMTDate != null ? ((Object)gMTDate).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LastModifiedVersion)) break block3;
                LastModifiedVersion lastModifiedVersion = (LastModifiedVersion)object;
                if (!Intrinsics.areEqual(this.lastModified, lastModifiedVersion.lastModified)) break block3;
            }
            return true;
        }
        return false;
    }
}

