/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public class ConfigurationSource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ConfigurationSource NULL_SOURCE = new ConfigurationSource(EMPTY_BYTE_ARRAY, null, 0L);
    public static final ConfigurationSource COMPOSITE_SOURCE = new ConfigurationSource(EMPTY_BYTE_ARRAY, null, 0L);
    private static final String HTTPS = "https";
    private final File file;
    private final URL url;
    private final String location;
    private final InputStream stream;
    private volatile byte[] data;
    private volatile Source source;
    private final long lastModified;
    private volatile long modifiedMillis;

    public ConfigurationSource(InputStream stream, File file) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.file = Objects.requireNonNull(file, "file is null");
        this.location = file.getAbsolutePath();
        this.url = null;
        this.data = null;
        long modified = 0L;
        try {
            modified = file.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastModified = modified;
    }

    public ConfigurationSource(InputStream stream, URL url2) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.url = Objects.requireNonNull(url2, "URL is null");
        this.location = url2.toString();
        this.file = null;
        this.data = null;
        this.lastModified = 0L;
    }

    public ConfigurationSource(InputStream stream, URL url2, long lastModified) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.url = Objects.requireNonNull(url2, "URL is null");
        this.location = url2.toString();
        this.file = null;
        this.data = null;
        this.lastModified = lastModified;
    }

    public ConfigurationSource(InputStream stream) throws IOException {
        this(ConfigurationSource.toByteArray(stream), null, 0L);
    }

    public ConfigurationSource(Source source2, byte[] data2, long lastModified) throws IOException {
        Objects.requireNonNull(source2, "source is null");
        this.data = Objects.requireNonNull(data2, "data is null");
        this.stream = new ByteArrayInputStream(data2);
        this.file = source2.getFile();
        this.url = source2.getURI().toURL();
        this.location = source2.getLocation();
        this.lastModified = lastModified;
    }

    private ConfigurationSource(byte[] data2, URL url2, long lastModified) {
        this.data = Objects.requireNonNull(data2, "data is null");
        this.stream = new ByteArrayInputStream(data2);
        this.file = null;
        this.url = url2;
        this.location = null;
        this.lastModified = lastModified;
        if (url2 == null) {
            this.data = data2;
        }
    }

    private static byte[] toByteArray(InputStream inputStream2) throws IOException {
        int buffSize = Math.max(4096, inputStream2.available());
        ByteArrayOutputStream contents = new ByteArrayOutputStream(buffSize);
        byte[] buff = new byte[buffSize];
        int length2 = inputStream2.read(buff);
        while (length2 > 0) {
            contents.write(buff, 0, length2);
            length2 = inputStream2.read(buff);
        }
        return contents.toByteArray();
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() {
        return this.url;
    }

    public void setSource(Source source2) {
        this.source = source2;
    }

    public void setData(byte[] data2) {
        this.data = data2;
    }

    public void setModifiedMillis(long modifiedMillis) {
        this.modifiedMillis = modifiedMillis;
    }

    public URI getURI() {
        URI sourceURI = null;
        if (this.url != null) {
            try {
                sourceURI = this.url.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (sourceURI == null && this.file != null) {
            sourceURI = this.file.toURI();
        }
        if (sourceURI == null && this.location != null) {
            try {
                sourceURI = new URI(this.location);
            }
            catch (URISyntaxException ex) {
                try {
                    sourceURI = new URI("file://" + this.location);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return sourceURI;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public ConfigurationSource resetInputStream() throws IOException {
        if (this.source != null) {
            return new ConfigurationSource(this.source, this.data, this.lastModified);
        }
        if (this.file != null) {
            return new ConfigurationSource((InputStream)new FileInputStream(this.file), this.file);
        }
        if (this.url != null && this.data != null) {
            return new ConfigurationSource(this.data, this.url, this.modifiedMillis == 0L ? this.lastModified : this.modifiedMillis);
        }
        if (this.url != null) {
            return ConfigurationSource.fromUri(this.getURI());
        }
        if (this.data != null) {
            return new ConfigurationSource(this.data, null, this.lastModified);
        }
        return null;
    }

    public String toString() {
        if (this.location != null) {
            return this.location;
        }
        if (this == NULL_SOURCE) {
            return "NULL_SOURCE";
        }
        int length2 = this.data == null ? -1 : this.data.length;
        return "stream (" + length2 + " bytes, unknown location)";
    }

    public static ConfigurationSource fromUri(URI configLocation) {
        File configFile = FileUtils.fileFromUri(configLocation);
        if (configFile != null && configFile.exists() && configFile.canRead()) {
            try {
                return new ConfigurationSource((InputStream)new FileInputStream(configFile), configFile);
            }
            catch (FileNotFoundException ex) {
                ConfigurationFactory.LOGGER.error("Cannot locate file {}", (Object)configLocation.getPath(), (Object)ex);
            }
        }
        if (ConfigurationFactory.isClassLoaderUri(configLocation)) {
            ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
            String path2 = ConfigurationFactory.extractClassLoaderUriPath(configLocation);
            return ConfigurationSource.fromResource(path2, loader);
        }
        if (!configLocation.isAbsolute()) {
            ConfigurationFactory.LOGGER.error("File not found in file system or classpath: {}", (Object)configLocation.toString());
            return null;
        }
        try {
            URL url2 = configLocation.toURL();
            URLConnection urlConnection = UrlConnectionFactory.createConnection(url2);
            InputStream is = urlConnection.getInputStream();
            long lastModified = urlConnection.getLastModified();
            return new ConfigurationSource(is, configLocation.toURL(), lastModified);
        }
        catch (FileNotFoundException ex) {
            ConfigurationFactory.LOGGER.warn("Could not locate file {}", (Object)configLocation.toString());
        }
        catch (MalformedURLException ex) {
            ConfigurationFactory.LOGGER.error("Invalid URL {}", (Object)configLocation.toString(), (Object)ex);
        }
        catch (Exception ex) {
            ConfigurationFactory.LOGGER.error("Unable to access {}", (Object)configLocation.toString(), (Object)ex);
        }
        return null;
    }

    public static ConfigurationSource fromResource(String resource, ClassLoader loader) {
        URL url2 = Loader.getResource(resource, loader);
        if (url2 == null) {
            return null;
        }
        return ConfigurationSource.getConfigurationSource(url2);
    }

    private static ConfigurationSource getConfigurationSource(URL url2) {
        try {
            SslConfiguration sslConfiguration;
            URLConnection urlConnection = url2.openConnection();
            AuthorizationProvider provider2 = ConfigurationFactory.authorizationProvider(PropertiesUtil.getProperties());
            provider2.addAuthorization(urlConnection);
            if (url2.getProtocol().equals(HTTPS) && (sslConfiguration = SslConfigurationFactory.getSslConfiguration()) != null) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslConfiguration.getSslSocketFactory());
                if (!sslConfiguration.isVerifyHostName()) {
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
                }
            }
            File file = FileUtils.fileFromUri(url2.toURI());
            try {
                if (file != null) {
                    return new ConfigurationSource(urlConnection.getInputStream(), FileUtils.fileFromUri(url2.toURI()));
                }
                return new ConfigurationSource(urlConnection.getInputStream(), url2, urlConnection.getLastModified());
            }
            catch (FileNotFoundException ex) {
                ConfigurationFactory.LOGGER.info("Unable to locate file {}, ignoring.", (Object)url2.toString());
                return null;
            }
        }
        catch (IOException | URISyntaxException ex) {
            ConfigurationFactory.LOGGER.warn("Error accessing {} due to {}, ignoring.", (Object)url2.toString(), (Object)ex.getMessage());
            return null;
        }
    }
}

