/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCIIUtility {
    private ASCIIUtility() {
    }

    public static int parseInt(byte[] b, int start2, int end2, int radix) throws NumberFormatException {
        if (b == null) {
            throw new NumberFormatException("null");
        }
        int result2 = 0;
        boolean negative = false;
        int i = start2;
        if (end2 > start2) {
            int digit;
            int limit;
            if (b[i] == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < end2) {
                if ((digit = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b, start2, end2));
                }
                result2 = -digit;
            }
            while (i < end2) {
                if ((digit = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= radix) < limit + digit) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= digit;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i > start2 + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static int parseInt(byte[] b, int start2, int end2) throws NumberFormatException {
        return ASCIIUtility.parseInt(b, start2, end2, 10);
    }

    public static long parseLong(byte[] b, int start2, int end2, int radix) throws NumberFormatException {
        if (b == null) {
            throw new NumberFormatException("null");
        }
        long result2 = 0L;
        boolean negative = false;
        int i = start2;
        if (end2 > start2) {
            int digit;
            long limit;
            if (b[i] == 45) {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)radix;
            if (i < end2) {
                if ((digit = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b, start2, end2));
                }
                result2 = -digit;
            }
            while (i < end2) {
                if ((digit = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= (long)digit;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i > start2 + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static long parseLong(byte[] b, int start2, int end2) throws NumberFormatException {
        return ASCIIUtility.parseLong(b, start2, end2, 10);
    }

    public static String toString(byte[] b, int start2, int end2) {
        int size2 = end2 - start2;
        char[] theChars = new char[size2];
        int i = 0;
        int j = start2;
        while (i < size2) {
            theChars[i++] = (char)(b[j++] & 0xFF);
        }
        return new String(theChars);
    }

    public static String toString(byte[] b) {
        return ASCIIUtility.toString(b, 0, b.length);
    }

    public static String toString(ByteArrayInputStream is) {
        int size2 = is.available();
        char[] theChars = new char[size2];
        byte[] bytes = new byte[size2];
        is.read(bytes, 0, size2);
        int i = 0;
        while (i < size2) {
            theChars[i] = (char)(bytes[i++] & 0xFF);
        }
        return new String(theChars);
    }

    public static byte[] getBytes(String s) {
        char[] chars = s.toCharArray();
        int size2 = chars.length;
        byte[] bytes = new byte[size2];
        int i = 0;
        while (i < size2) {
            bytes[i] = (byte)chars[i++];
        }
        return bytes;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size2 = 1024;
        if (is instanceof ByteArrayInputStream) {
            size2 = is.available();
            buf = new byte[size2];
            int len = is.read(buf, 0, size2);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size2];
            while ((len = is.read(buf, 0, size2)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }
}

