/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0007\u001a\u001f\u0010\u0004\u001a\u0004\u0018\u00010\b*\u00020\u00072\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0007\u00a2\u0006\u0002\u0010\t\u001a\u0011\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0003\u00a2\u0006\u0002\u0010\f\u001a\u0011\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0007\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0003\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0007\u001a\u0012\u0010\u0010\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u0007\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0003\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0007\u001a\u0012\u0010\u0017\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0016\u001a\u0012\u0010\u0019\u001a\u00020\b*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000f\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u0003\u001a\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u0016H\u0000\u001a\u0012\u0010\u001d\u001a\u00020\b*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0016\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0001*\u00020\u0003\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0001*\u00020\u0007\u00a8\u0006 "}, d2={"cacheControl", "", "Lio/ktor/http/HeaderValue;", "Lio/ktor/http/HttpMessage;", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "Lio/ktor/http/HttpMessageBuilder;", "", "(Lio/ktor/http/HttpMessageBuilder;Ljava/nio/charset/Charset;)Lkotlin/Unit;", "contentLength", "", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "length", "", "contentType", "Lio/ktor/http/ContentType;", "type", "cookies", "Lio/ktor/http/Cookie;", "etag", "", "ifNoneMatch", "value", "maxAge", "seconds", "setCookie", "splitSetCookieHeader", "userAgent", "content", "vary", "ktor-http"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(@NotNull HttpMessageBuilder $this$contentType, @NotNull ContentType type2) {
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        $this$contentType.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type2.toString());
    }

    @Deprecated(message="Content-Length is controlled by underlying engine. Don't specify it explicitly.", level=DeprecationLevel.ERROR)
    public static final void contentLength(@NotNull HttpMessageBuilder $this$contentLength, int length2) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        $this$contentLength.getHeaders().set(HttpHeaders.INSTANCE.getContentLength(), String.valueOf(length2));
    }

    @Deprecated(message="Use content with particular content type and charset instead", level=DeprecationLevel.ERROR)
    @Nullable
    public static final Unit charset(@NotNull HttpMessageBuilder $this$charset, @NotNull Charset charset) {
        Unit unit;
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        if (contentType2 == null) {
            unit = null;
        } else {
            ContentType it = contentType2;
            boolean bl = false;
            HttpMessagePropertiesKt.contentType($this$charset, ContentTypesKt.withCharset(it, charset));
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $this$maxAge, int seconds) {
        Intrinsics.checkNotNullParameter($this$maxAge, "<this>");
        $this$maxAge.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), Intrinsics.stringPlus("max-age=", seconds));
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $this$ifNoneMatch, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$ifNoneMatch, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$ifNoneMatch.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $this$userAgent, @NotNull String content2) {
        Intrinsics.checkNotNullParameter($this$userAgent, "<this>");
        Intrinsics.checkNotNullParameter(content2, "content");
        $this$userAgent.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content2);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string == null) {
            contentType2 = null;
        } else {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 == null ? null : ContentTypesKt.charset(contentType2);
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $this$etag) {
        Intrinsics.checkNotNullParameter($this$etag, "<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter($this$vary, "<this>");
        String string = $this$vary.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (string == null) {
            list = null;
        } else {
            String[] stringArray = new String[]{","};
            List list2 = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                list = (List)destination$iv$iv;
            }
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessageBuilder $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string == null ? null : Long.valueOf(Long.parseLong(string));
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string == null) {
            contentType2 = null;
        } else {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 == null ? null : ContentTypesKt.charset(contentType2);
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $this$etag) {
        Intrinsics.checkNotNullParameter($this$etag, "<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter($this$vary, "<this>");
        String string = $this$vary.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (string == null) {
            list = null;
        } else {
            String[] stringArray = new String[]{","};
            List list2 = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                list = (List)destination$iv$iv;
            }
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessage $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string == null ? null : Long.valueOf(Long.parseLong(string));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $this$setCookie) {
        List list;
        Intrinsics.checkNotNullParameter($this$setCookie, "<this>");
        List<String> list2 = $this$setCookie.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            String it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Iterable iterable = list2;
            boolean $i$f$flatMap = false;
            void var6_4 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = HttpMessagePropertiesKt.splitSetCookieHeader(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            $this$flatMap$iv = list3;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader(it));
            }
            list = (List)destination$iv$iv;
        }
        List list4 = list;
        return list4 == null ? CollectionsKt.emptyList() : list4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $this$cookies) {
        List list;
        Intrinsics.checkNotNullParameter($this$cookies, "<this>");
        List<String> list2 = $this$cookies.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv;
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    public static final List<HeaderValue> cacheControl(@NotNull HttpMessage $this$cacheControl) {
        List<HeaderValue> list;
        Intrinsics.checkNotNullParameter($this$cacheControl, "<this>");
        String string = $this$cacheControl.getHeaders().get(HttpHeaders.INSTANCE.getCacheControl());
        if (string == null) {
            list = null;
        } else {
            String it = string;
            boolean bl = false;
            list = HttpHeaderValueParserKt.parseHeaderValue(it);
        }
        List<HeaderValue> list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    @NotNull
    public static final List<String> splitSetCookieHeader(@NotNull String $this$splitSetCookieHeader) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter($this$splitSetCookieHeader, "<this>");
        int comma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', 0, false, 6, null);
        if (comma == -1) {
            return CollectionsKt.listOf($this$splitSetCookieHeader);
        }
        List result2 = new ArrayList();
        int current = 0;
        int equals2 = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, '=', comma, false, 4, null);
        int semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ';', comma, false, 4, null);
        while (current < $this$splitSetCookieHeader.length() && comma > 0) {
            String string2;
            if (equals2 < comma) {
                equals2 = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, '=', comma, false, 4, null);
            }
            int nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', comma + 1, false, 4, null);
            while (nextComma >= 0 && nextComma < equals2) {
                comma = nextComma;
                nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', nextComma + 1, false, 4, null);
            }
            if (semicolon < comma) {
                semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ';', comma, false, 4, null);
            }
            if (equals2 < 0) {
                object = result2;
                string2 = $this$splitSetCookieHeader.substring(current);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                string = string2;
                object.add(string);
                return result2;
            }
            if (semicolon == -1 || semicolon > equals2) {
                object = result2;
                string2 = $this$splitSetCookieHeader.substring(current, comma);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string2;
                object.add(string);
                current = comma + 1;
            }
            comma = nextComma;
        }
        if (current < $this$splitSetCookieHeader.length()) {
            Collection collection = result2;
            string = $this$splitSetCookieHeader.substring(current);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            object = string;
            collection.add(object);
        }
        return result2;
    }
}

