/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.converters;

import io.ktor.util.converters.ConversionService;
import io.ktor.util.converters.ConversionServiceJvmKt;
import io.ktor.util.converters.DataConversionException;
import io.ktor.util.reflect.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J \u0010\n\u001a\u0004\u0018\u00010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0013"}, d2={"Lio/ktor/util/converters/DefaultConversionService;", "Lio/ktor/util/converters/ConversionService;", "()V", "convertPrimitives", "", "klass", "Lkotlin/reflect/KClass;", "value", "", "fromValue", "fromValues", "values", "", "type", "Lio/ktor/util/reflect/TypeInfo;", "throwConversionException", "", "typeName", "toValues", "ktor-utils"})
public final class DefaultConversionService
implements ConversionService {
    @NotNull
    public static final DefaultConversionService INSTANCE = new DefaultConversionService();

    private DefaultConversionService() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> toValues(@Nullable Object value) {
        List<String> list;
        if (value == null) {
            return CollectionsKt.emptyList();
        }
        List<String> converted = ConversionServiceJvmKt.platformDefaultToValues(value);
        if (converted != null) {
            return converted;
        }
        if (value instanceof Iterable) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)value;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.toValues(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List<String>)destination$iv$iv;
        } else {
            KClass klass = Reflection.getOrCreateKotlinClass(value.getClass());
            if (((((((Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Float.TYPE))) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Double.TYPE))) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Long.TYPE))) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Short.TYPE))) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Character.TYPE))) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(Boolean.TYPE))) ? true : Intrinsics.areEqual(klass, Reflection.getOrCreateKotlinClass(String.class))) {
                list = CollectionsKt.listOf(value.toString());
            } else {
                throw new DataConversionException("Class " + klass + " is not supported in default data conversion service");
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object fromValues(@NotNull List<String> values2, @NotNull TypeInfo type2) {
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (values2.isEmpty()) {
            return null;
        }
        if (Intrinsics.areEqual(type2.getType(), Reflection.getOrCreateKotlinClass(List.class))) {
            KClass argumentType;
            KClassifier kClassifier;
            KType kType = type2.getKotlinType();
            if (kType == null) {
                kClassifier = null;
            } else {
                List<KTypeProjection> list = kType.getArguments();
                if (list == null) {
                    kClassifier = null;
                } else {
                    KTypeProjection kTypeProjection = CollectionsKt.single(list);
                    if (kTypeProjection == null) {
                        kClassifier = null;
                    } else {
                        KType kType2 = kTypeProjection.getType();
                        kClassifier = kType2 == null ? null : kType2.getClassifier();
                    }
                }
            }
            KClassifier kClassifier2 = kClassifier;
            KClass kClass = argumentType = kClassifier2 instanceof KClass ? (KClass)kClassifier2 : null;
            if (argumentType != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = values2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.fromValue((String)it, argumentType));
                }
                return (List)destination$iv$iv;
            }
        }
        if (values2.isEmpty()) {
            throw new DataConversionException(Intrinsics.stringPlus("There are no values when trying to construct single value ", type2));
        }
        if (values2.size() > 1) {
            throw new DataConversionException(Intrinsics.stringPlus("There are multiple values when trying to construct single value ", type2));
        }
        return this.fromValue(CollectionsKt.single(values2), type2.getType());
    }

    @NotNull
    public final Object fromValue(@NotNull String value, @NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(klass, "klass");
        Object converted = this.convertPrimitives(klass, value);
        if (converted != null) {
            return converted;
        }
        Object platformConverted = ConversionServiceJvmKt.platformDefaultFromValues(value, klass);
        if (platformConverted != null) {
            return platformConverted;
        }
        this.throwConversionException(klass.toString());
        throw new KotlinNothingValueException();
    }

    private final Object convertPrimitives(KClass<?> klass, String value) {
        KClass<?> kClass = klass;
        return Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? Integer.valueOf(Integer.parseInt(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Float.TYPE)) ? Float.valueOf(Float.parseFloat(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Double.TYPE)) ? Double.valueOf(Double.parseDouble(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.TYPE)) ? Long.valueOf(Long.parseLong(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE)) ? Short.valueOf(Short.parseShort(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Character.TYPE)) ? Character.valueOf(StringsKt.single(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? Boolean.valueOf(Boolean.parseBoolean(value)) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(String.class)) ? value : null)))))));
    }

    private final Void throwConversionException(String typeName) {
        throw new DataConversionException("Type " + typeName + " is not supported in default data conversion service");
    }
}

