/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0003J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lio/ktor/http/HeaderValueWithParameters;", "", "content", "", "parameters", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Ljava/util/List;)V", "getContent", "()Ljava/lang/String;", "getParameters", "()Ljava/util/List;", "parameter", "name", "toString", "Companion", "ktor-http"})
public abstract class HeaderValueWithParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @NotNull
    private final List<HeaderValueParam> parameters;

    public HeaderValueWithParameters(@NotNull String content2, @NotNull List<HeaderValueParam> parameters2) {
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this.content = content2;
        this.parameters = parameters2;
    }

    public /* synthetic */ HeaderValueWithParameters(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    @NotNull
    protected final String getContent() {
        return this.content;
    }

    @NotNull
    public final List<HeaderValueParam> getParameters() {
        return this.parameters;
    }

    @Nullable
    public final String parameter(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$firstOrNull$iv = this.parameters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HeaderValueParam it = (HeaderValueParam)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), name, true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        HeaderValueParam headerValueParam = v0;
        return headerValueParam == null ? null : headerValueParam.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        if (this.parameters.isEmpty()) {
            string = this.content;
        } else {
            int n;
            void $this$sumBy$iv;
            Object object = this.parameters;
            int n2 = this.content.length();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                HeaderValueParam headerValueParam = (HeaderValueParam)element$iv;
                n = sum$iv;
                boolean bl = false;
                int n3 = it.getName().length() + it.getValue().length() + 3;
                sum$iv = n + n3;
            }
            n = sum$iv;
            int size2 = n2 + n;
            Object $this$toString_u24lambda_u2d2 = object = new StringBuilder(size2);
            boolean bl = false;
            ((StringBuilder)$this$toString_u24lambda_u2d2).append(this.getContent());
            int n4 = 0;
            int n5 = this.getParameters().size();
            while (n4 < n5) {
                int index = n4++;
                HeaderValueParam headerValueParam = this.getParameters().get(index);
                String name = headerValueParam.component1();
                String value = headerValueParam.component2();
                ((StringBuilder)$this$toString_u24lambda_u2d2).append("; ");
                ((StringBuilder)$this$toString_u24lambda_u2d2).append(name);
                ((StringBuilder)$this$toString_u24lambda_u2d2).append("=");
                String $this$escapeIfNeededTo$iv = value;
                boolean $i$f$escapeIfNeededTo = false;
                if (HeaderValueWithParametersKt.access$checkNeedEscape($this$escapeIfNeededTo$iv)) {
                    ((StringBuilder)$this$toString_u24lambda_u2d2).append(HeaderValueWithParametersKt.quote($this$escapeIfNeededTo$iv));
                    continue;
                }
                ((StringBuilder)$this$toString_u24lambda_u2d2).append($this$escapeIfNeededTo$iv);
            }
            String string2 = ((StringBuilder)object).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "{\n            val size =\u2026   }.toString()\n        }");
            string = string2;
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u0002H\u00040\bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\f"}, d2={"Lio/ktor/http/HeaderValueWithParameters$Companion;", "", "()V", "parse", "R", "value", "", "init", "Lkotlin/Function2;", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public final <R> R parse(@NotNull String value, @NotNull Function2<? super String, ? super List<HeaderValueParam>, ? extends R> init) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(init, "init");
            boolean $i$f$parse = false;
            HeaderValue headerValue = CollectionsKt.single(HttpHeaderValueParserKt.parseHeaderValue(value));
            return init.invoke(headerValue.getValue(), headerValue.getParams());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

