/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.util.InternalAPI;
import io.ktor.util.internal.LockFreeLinkedListHead;
import io.ktor.util.internal.LockFreeLinkedListNode;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.ChildHandle;
import kotlinx.coroutines.ChildJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.selects.SelectClause0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0004\"#$%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0002J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u000eJ \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ@\u0010\u001c\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102'\u0010\u001d\u001a#\b\u0001\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\b H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue;", "", "timeoutMillis", "", "clock", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)V", "cancelled", "", "head", "Lio/ktor/util/internal/LockFreeLinkedListHead;", "getTimeoutMillis", "()J", "cancel", "", "checkCancellation", "T", "continuation", "Lkotlin/coroutines/Continuation;", "count", "", "count$ktor_http_cio", "process", "now", "register", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "job", "Lkotlinx/coroutines/Job;", "withTimeout", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Cancellable", "JobTask", "Registration", "WeakTimeoutCoroutine", "ktor-http-cio"})
public final class WeakTimeoutQueue {
    private final long timeoutMillis;
    @NotNull
    private final Function0<Long> clock;
    @NotNull
    private final LockFreeLinkedListHead head;
    private volatile boolean cancelled;

    public WeakTimeoutQueue(long timeoutMillis, @NotNull Function0<Long> clock) {
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.timeoutMillis = timeoutMillis;
        this.clock = clock;
        this.head = new LockFreeLinkedListHead();
    }

    public /* synthetic */ WeakTimeoutQueue(long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(l, function0);
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @NotNull
    public final Registration register(@NotNull Job job2) {
        Intrinsics.checkNotNullParameter(job2, "job");
        long now = ((Number)this.clock.invoke()).longValue();
        LockFreeLinkedListHead head2 = this.head;
        if (this.cancelled) {
            throw new CancellationException();
        }
        JobTask cancellable = new JobTask(now + this.timeoutMillis, job2);
        head2.addLast(cancellable);
        this.process(now, head2, this.cancelled);
        if (this.cancelled) {
            cancellable.cancel();
            throw new CancellationException();
        }
        return cancellable;
    }

    public final void cancel() {
        this.cancelled = true;
        this.process();
    }

    public final void process() {
        this.process(((Number)this.clock.invoke()).longValue(), this.head, this.cancelled);
    }

    public final int count$ktor_http_cio() {
        int count2 = 0;
        LockFreeLinkedListHead this_$iv = this.head;
        boolean $i$f$forEach = false;
        LockFreeLinkedListNode cur$iv = (LockFreeLinkedListNode)this_$iv.getNext();
        while (!Intrinsics.areEqual(cur$iv, this_$iv)) {
            if (cur$iv instanceof Cancellable) {
                Cancellable it = (Cancellable)cur$iv;
                boolean bl = false;
                int n = count2;
                count2 = n + 1;
            }
            cur$iv = cur$iv.getNextNode();
        }
        return count2;
    }

    @Nullable
    public final <T> Object withTimeout(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block2, @NotNull Continuation<? super T> $completion) {
        Object object;
        Continuation<T> rawContinuation = $completion;
        boolean bl = false;
        if (!JobKt.isActive(rawContinuation.getContext())) {
            this.checkCancellation(rawContinuation);
        }
        Continuation<T> continuation2 = IntrinsicsKt.intercepted(rawContinuation);
        WeakTimeoutCoroutine wrapped = new WeakTimeoutCoroutine(continuation2.getContext(), continuation2, null, 4, null);
        Registration handle2 = this.register(wrapped);
        wrapped.invokeOnCompletion(handle2);
        try {
            if (wrapped.isCancelled()) {
                throw wrapped.getCancellationException();
            }
            object = ((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(block2, 2)).invoke(wrapped, (Continuation)wrapped);
        }
        catch (Throwable t) {
            if (wrapped.tryComplete()) {
                handle2.dispose();
                throw t;
            }
            object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        Object result2 = object;
        if (result2 != IntrinsicsKt.getCOROUTINE_SUSPENDED() && wrapped.tryComplete()) {
            handle2.dispose();
        }
        Object object2 = result2;
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object2;
    }

    private final <T> void checkCancellation(Continuation<? super T> continuation2) {
        Job job2 = (Job)continuation2.getContext().get(Job.Key);
        if (job2 != null) {
            Job job3 = job2;
            boolean bl = false;
            if (job3.isCancelled()) {
                throw job3.getCancellationException();
            }
        }
    }

    private final void process(long now, LockFreeLinkedListHead head2, boolean cancelled) {
        Object object;
        while (((object = head2.getNext()) instanceof Cancellable ? (Cancellable)object : null) != null) {
            Cancellable p;
            p = p;
            if (!cancelled && p.getDeadline() > now) break;
            if (!p.isActive() || !p.remove()) continue;
            p.cancel();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002#\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00072\u00020\bJ\u0013\u0010\t\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a8\u0006\n"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "cause", "", "Lkotlinx/coroutines/CompletionHandler;", "Lkotlinx/coroutines/DisposableHandle;", "invoke", "ktor-http-cio"})
    public static interface Registration
    extends Function1<Throwable, Unit>,
    DisposableHandle {
        @Override
        public void invoke(@Nullable Throwable var1);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void invoke(@NotNull Registration this_, @Nullable Throwable cause) {
                Intrinsics.checkNotNullParameter(this_, "this");
                this_.dispose();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "Lio/ktor/util/internal/LockFreeLinkedListNode;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "deadline", "", "(J)V", "getDeadline", "()J", "isActive", "", "()Z", "cancel", "", "dispose", "ktor-http-cio"})
    private static abstract class Cancellable
    extends LockFreeLinkedListNode
    implements Registration {
        private final long deadline;

        public Cancellable(long deadline) {
            this.deadline = deadline;
        }

        public final long getDeadline() {
            return this.deadline;
        }

        public boolean isActive() {
            return !this.isRemoved();
        }

        public abstract void cancel();

        @Override
        public void dispose() {
            this.remove();
        }

        @Override
        public void invoke(@Nullable Throwable cause) {
            Registration.DefaultImpls.invoke(this, cause);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$JobTask;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "deadline", "", "job", "Lkotlinx/coroutines/Job;", "(JLkotlinx/coroutines/Job;)V", "isActive", "", "()Z", "cancel", "", "ktor-http-cio"})
    private static final class JobTask
    extends Cancellable {
        @NotNull
        private final Job job;

        public JobTask(long deadline, @NotNull Job job2) {
            Intrinsics.checkNotNullParameter(job2, "job");
            super(deadline);
            this.job = job2;
        }

        @Override
        public boolean isActive() {
            return super.isActive() && this.job.isActive();
        }

        @Override
        public void cancel() {
            Job.DefaultImpls.cancel$default(this.job, null, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0002\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u00028\u00000\u00042\u00020\u00062\u00020UB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0097\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u0097\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001c\u0010\u0010\u001a\u00020\u00142\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0097\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0015J\"\u0010\u0010\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0013\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017H\u0096\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0018J8\u0010\u001e\u001a\u00028\u0001\"\u0004\b\u0001\u0010\u00192\u0006\u0010\u001a\u001a\u00028\u00012\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00028\u00010\u001bH\u0096\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ*\u0010#\u001a\u0004\u0018\u00018\u0001\"\b\b\u0001\u0010 *\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0096\u0003\u00a2\u0006\u0004\b#\u0010$J\u0014\u0010%\u001a\u00060\u0016j\u0002`\u0017H\u0097\u0001\u00a2\u0006\u0004\b%\u0010&JM\u0010/\u001a\u00020.2\b\b\u0002\u0010'\u001a\u00020\u00142\b\b\u0002\u0010(\u001a\u00020\u00142'\u0010-\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0012\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000f0)j\u0002`,H\u0097\u0001\u00a2\u0006\u0004\b/\u00100J9\u0010/\u001a\u00020.2'\u0010-\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0012\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000f0)j\u0002`,H\u0096\u0001\u00a2\u0006\u0004\b/\u00101J\u0013\u00102\u001a\u00020\u000fH\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0004\b2\u00103J\u001c\u00104\u001a\u00020\u00022\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030!H\u0096\u0001\u00a2\u0006\u0004\b4\u00105J\u0018\u00106\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0003\u00a2\u0006\u0004\b6\u00107J\u0018\u00106\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0097\u0003\u00a2\u0006\u0004\b6\u00109J \u0010<\u001a\u00020\u000f2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000:H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=J\u0010\u0010>\u001a\u00020\u0014H\u0096\u0001\u00a2\u0006\u0004\b>\u0010?J\r\u0010@\u001a\u00020\u0014\u00a2\u0006\u0004\b@\u0010?R\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00060A8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010E\u001a\u0004\bF\u0010GR\u0014\u0010I\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010GR\u0014\u0010J\u001a\u00020\u00148\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bJ\u0010?R\u0014\u0010K\u001a\u00020\u00148\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u0010?R\u0014\u0010L\u001a\u00020\u00148\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bL\u0010?R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010MR\u0018\u0010\"\u001a\u0006\u0012\u0002\b\u00030!8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0014\u0010S\u001a\u00020P8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006T"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$WeakTimeoutCoroutine;", "T", "Lkotlin/coroutines/CoroutineContext;", "context", "Lkotlin/coroutines/Continuation;", "delegate", "Lkotlinx/coroutines/Job;", "job", "<init>", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;Lkotlinx/coroutines/Job;)V", "Lkotlinx/coroutines/ChildJob;", "child", "Lkotlinx/coroutines/ChildHandle;", "attachChild", "(Lkotlinx/coroutines/ChildJob;)Lkotlinx/coroutines/ChildHandle;", "", "cancel", "()V", "", "cause", "", "(Ljava/lang/Throwable;)Z", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "(Ljava/util/concurrent/CancellationException;)V", "R", "initial", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext$Element;", "operation", "fold", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "E", "Lkotlin/coroutines/CoroutineContext$Key;", "key", "get", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;", "getCancellationException", "()Ljava/util/concurrent/CancellationException;", "onCancelling", "invokeImmediately", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lkotlinx/coroutines/CompletionHandler;", "handler", "Lkotlinx/coroutines/DisposableHandle;", "invokeOnCompletion", "(ZZLkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/DisposableHandle;", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/DisposableHandle;", "join", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "minusKey", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext;", "plus", "(Lkotlin/coroutines/CoroutineContext;)Lkotlin/coroutines/CoroutineContext;", "other", "(Lkotlinx/coroutines/Job;)Lkotlinx/coroutines/Job;", "Lkotlin/Result;", "result", "resumeWith", "(Ljava/lang/Object;)V", "start", "()Z", "tryComplete", "Lkotlin/sequences/Sequence;", "getChildren", "()Lkotlin/sequences/Sequence;", "children", "Lkotlin/coroutines/CoroutineContext;", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "coroutineContext", "isActive", "isCancelled", "isCompleted", "Lkotlinx/coroutines/Job;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "Lkotlinx/coroutines/selects/SelectClause0;", "getOnJoin", "()Lkotlinx/coroutines/selects/SelectClause0;", "onJoin", "ktor-http-cio", "Lkotlinx/coroutines/CoroutineScope;"})
    private static final class WeakTimeoutCoroutine<T>
    implements Continuation<T>,
    Job,
    CoroutineScope {
        @NotNull
        private final Job job;
        @NotNull
        private final CoroutineContext context;
        @NotNull
        private volatile /* synthetic */ Object state;
        private static final /* synthetic */ AtomicReferenceFieldUpdater state$FU;

        public WeakTimeoutCoroutine(@NotNull CoroutineContext context2, @NotNull Continuation<? super T> delegate2, @NotNull Job job2) {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(delegate2, "delegate");
            Intrinsics.checkNotNullParameter(job2, "job");
            this.job = job2;
            this.context = context2.plus(this.job);
            this.state = delegate2;
        }

        public /* synthetic */ WeakTimeoutCoroutine(CoroutineContext coroutineContext2, Continuation continuation2, Job job2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                job2 = JobKt.Job((Job)coroutineContext2.get(Job.Key));
            }
            this(coroutineContext2, continuation2, job2);
        }

        @Override
        @NotNull
        public Sequence<Job> getChildren() {
            return this.job.getChildren();
        }

        @Override
        public boolean isActive() {
            return this.job.isActive();
        }

        @Override
        public boolean isCancelled() {
            return this.job.isCancelled();
        }

        @Override
        public boolean isCompleted() {
            return this.job.isCompleted();
        }

        @Override
        @NotNull
        public CoroutineContext.Key<?> getKey() {
            return this.job.getKey();
        }

        @Override
        @NotNull
        public SelectClause0 getOnJoin() {
            return this.job.getOnJoin();
        }

        @Override
        @InternalCoroutinesApi
        @NotNull
        public ChildHandle attachChild(@NotNull ChildJob child) {
            Intrinsics.checkNotNullParameter(child, "child");
            return this.job.attachChild(child);
        }

        @Override
        @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
        public /* synthetic */ void cancel() {
            this.job.cancel();
        }

        @Override
        @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
        public /* synthetic */ boolean cancel(Throwable cause) {
            return this.job.cancel(cause);
        }

        @Override
        public void cancel(@Nullable CancellationException cause) {
            this.job.cancel(cause);
        }

        @Override
        public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            return this.job.fold(initial, operation);
        }

        @Override
        @Nullable
        public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.job.get(key);
        }

        @Override
        @InternalCoroutinesApi
        @NotNull
        public CancellationException getCancellationException() {
            return this.job.getCancellationException();
        }

        @Override
        @InternalCoroutinesApi
        @NotNull
        public DisposableHandle invokeOnCompletion(boolean onCancelling, boolean invokeImmediately, @NotNull Function1<? super Throwable, Unit> handler2) {
            Intrinsics.checkNotNullParameter(handler2, "handler");
            return this.job.invokeOnCompletion(onCancelling, invokeImmediately, handler2);
        }

        @Override
        @NotNull
        public DisposableHandle invokeOnCompletion(@NotNull Function1<? super Throwable, Unit> handler2) {
            Intrinsics.checkNotNullParameter(handler2, "handler");
            return this.job.invokeOnCompletion(handler2);
        }

        @Override
        @Nullable
        public Object join(@NotNull Continuation<? super Unit> $completion) {
            return this.job.join($completion);
        }

        @Override
        @NotNull
        public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.job.minusKey(key);
        }

        @Override
        @NotNull
        public CoroutineContext plus(@NotNull CoroutineContext context2) {
            Intrinsics.checkNotNullParameter(context2, "context");
            return this.job.plus(context2);
        }

        @Override
        @Deprecated(message="Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.", level=DeprecationLevel.ERROR)
        @NotNull
        public Job plus(@NotNull Job other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.job.plus(other);
        }

        @Override
        public boolean start() {
            return this.job.start();
        }

        @Override
        @NotNull
        public CoroutineContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public CoroutineContext getCoroutineContext() {
            return this.getContext();
        }

        @Override
        public void resumeWith(@NotNull Object result2) {
            Object upd$iv;
            Object cur$iv;
            WeakTimeoutCoroutine $this$getAndUpdate$iv = this;
            boolean $i$f$getAndUpdate = false;
            do {
                cur$iv = $this$getAndUpdate$iv.state;
                Continuation it = (Continuation)cur$iv;
                boolean bl = false;
                if (it != null) continue;
                return;
            } while (!state$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = null));
            Continuation continuation2 = (Continuation)cur$iv;
            if (continuation2 != null) {
                Continuation it = continuation2;
                boolean bl = false;
                it.resumeWith(result2);
                Job.DefaultImpls.cancel$default(this.job, null, 1, null);
            }
        }

        public final boolean tryComplete() {
            Object upd$iv;
            Object cur$iv;
            WeakTimeoutCoroutine $this$update$iv = this;
            boolean $i$f$update = false;
            do {
                cur$iv = $this$update$iv.state;
                Continuation it = (Continuation)cur$iv;
                boolean bl = false;
                if (it != null) continue;
                return false;
            } while (!state$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = null));
            Job.DefaultImpls.cancel$default(this.job, null, 1, null);
            return true;
        }

        static {
            state$FU = AtomicReferenceFieldUpdater.newUpdater(WeakTimeoutCoroutine.class, Object.class, "state");
        }
    }
}

