/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.cio.ChunkedTransferEncodingKt;
import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.internals.CharsKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelJVMKt;
import io.ktor.utils.io.ByteWriteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001a=\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"expectHttpBody", "", "method", "Lio/ktor/http/HttpMethod;", "contentLength", "", "transferEncoding", "", "connectionOptions", "Lio/ktor/http/cio/ConnectionOptions;", "contentType", "request", "Lio/ktor/http/cio/Request;", "expectHttpUpgrade", "upgrade", "isTransferEncodingChunked", "parseHttpBody", "", "headers", "Lio/ktor/http/cio/HttpHeadersMap;", "input", "Lio/ktor/utils/io/ByteReadChannel;", "out", "Lio/ktor/utils/io/ByteWriteChannel;", "(Lio/ktor/http/cio/HttpHeadersMap;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-http-cio"})
public final class HttpBodyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean expectHttpUpgrade(@NotNull HttpMethod method, @Nullable CharSequence upgrade, @Nullable ConnectionOptions connectionOptions) {
        Intrinsics.checkNotNullParameter(method, "method");
        if (!Intrinsics.areEqual(method, HttpMethod.Companion.getGet())) return false;
        if (upgrade == null) return false;
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 == null) {
            return false;
        }
        if (!connectionOptions2.getUpgrade()) return false;
        return true;
    }

    public static final boolean expectHttpUpgrade(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        return HttpBodyKt.expectHttpUpgrade(request2.getMethod(), request2.getHeaders().get("Upgrade"), ConnectionOptions.Companion.parse(request2.getHeaders().get("Connection")));
    }

    public static final boolean expectHttpBody(@NotNull HttpMethod method, long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @Nullable CharSequence contentType2) {
        Intrinsics.checkNotNullParameter(method, "method");
        if (transferEncoding != null) {
            HttpBodyKt.isTransferEncodingChunked(transferEncoding);
            return true;
        }
        if (contentLength != -1L) {
            return contentLength > 0L;
        }
        if (contentType2 != null) {
            return true;
        }
        if (Intrinsics.areEqual(method, HttpMethod.Companion.getGet()) || Intrinsics.areEqual(method, HttpMethod.Companion.getHead()) || Intrinsics.areEqual(method, HttpMethod.Companion.getOptions())) {
            return false;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        return connectionOptions2 == null ? false : connectionOptions2.getClose();
    }

    public static final boolean expectHttpBody(@NotNull Request request2) {
        long l;
        Intrinsics.checkNotNullParameter(request2, "request");
        CharSequence charSequence = request2.getHeaders().get("Content-Length");
        return HttpBodyKt.expectHttpBody(request2.getMethod(), charSequence == null ? -1L : (l = CharsKt.parseDecLong(charSequence)), request2.getHeaders().get("Transfer-Encoding"), ConnectionOptions.Companion.parse(request2.getHeaders().get("Connection")), request2.getHeaders().get("Content-Type"));
    }

    @Nullable
    public static final Object parseHttpBody(long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @NotNull ByteReadChannel input2, @NotNull ByteWriteChannel out2, @NotNull Continuation<? super Unit> $completion) {
        if (transferEncoding != null && HttpBodyKt.isTransferEncodingChunked(transferEncoding)) {
            Object object = ChunkedTransferEncodingKt.decodeChunked(input2, out2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (contentLength != -1L) {
            Object object = ByteReadChannelJVMKt.copyTo(input2, out2, contentLength, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 == null ? false : connectionOptions2.getClose()) {
            Object object = ByteReadChannelJVMKt.copyTo(input2, out2, Long.MAX_VALUE, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        IllegalStateException cause = new IllegalStateException("Failed to parse request body: request body length should be specified,\nchunked transfer encoding should be used or\nkeep-alive should be disabled (connection: close)");
        out2.close(cause);
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object parseHttpBody(@NotNull HttpHeadersMap headers, @NotNull ByteReadChannel input2, @NotNull ByteWriteChannel out2, @NotNull Continuation<? super Unit> $completion) {
        long l;
        CharSequence charSequence = headers.get("Content-Length");
        Object object = HttpBodyKt.parseHttpBody(charSequence == null ? -1L : (l = CharsKt.parseDecLong(charSequence)), headers.get("Transfer-Encoding"), ConnectionOptions.Companion.parse(headers.get("Connection")), input2, out2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean isTransferEncodingChunked(CharSequence transferEncoding) {
        if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "chunked", 3, null)) {
            return true;
        }
        if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "identity", 3, null)) {
            return false;
        }
        boolean chunked = false;
        String[] stringArray = new String[]{","};
        Iterable $this$forEach$iv = StringsKt.split$default(transferEncoding, stringArray, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String string = ((Object)StringsKt.trim((CharSequence)it)).toString().toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase()");
            String name = string;
            if (Intrinsics.areEqual(name, "chunked")) {
                if (chunked) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("Double-chunked TE is not supported: ", transferEncoding));
                }
                chunked = true;
                continue;
            }
            if (Intrinsics.areEqual(name, "identity")) continue;
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unsupported transfer encoding ", name));
        }
        return chunked;
    }
}

