/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features;

import io.ktor.client.features.HttpTimeout;
import io.ktor.client.request.HttpRequestBuilder;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/client/features/HttpRequestTimeoutException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "(Lio/ktor/client/request/HttpRequestBuilder;)V", "ktor-client-core"})
public final class HttpRequestTimeoutException
extends CancellationException {
    public HttpRequestTimeoutException(@NotNull HttpRequestBuilder request2) {
        Object object;
        Intrinsics.checkNotNullParameter(request2, "request");
        StringBuilder stringBuilder = new StringBuilder().append("Request timeout has expired [url=").append(request2.getUrl().buildString()).append(", request_timeout=");
        HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Feature);
        if (httpTimeoutCapabilityConfiguration == null) {
            object = "unknown";
        } else {
            object = httpTimeoutCapabilityConfiguration.getRequestTimeoutMillis();
            if (object == null) {
                object = "unknown";
            }
        }
        super(stringBuilder.append(object).append(" ms]").toString());
    }
}

