/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.gaffer;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.gaffer.GafferConfigurator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.StatusManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;

public class GafferUtil {
    private static String ERROR_MSG = "Failed to instantiate ch.qos.logback.classic.gaffer.GafferConfigurator";

    public static void runGafferConfiguratorOn(LoggerContext loggerContext, Object origin2, File configFile) {
        GafferConfigurator gafferConfigurator = GafferUtil.newGafferConfiguratorInstance(loggerContext, origin2);
        if (gafferConfigurator != null) {
            gafferConfigurator.run(configFile);
        }
    }

    public static void runGafferConfiguratorOn(LoggerContext loggerContext, Object origin2, URL configFile) {
        GafferConfigurator gafferConfigurator = GafferUtil.newGafferConfiguratorInstance(loggerContext, origin2);
        if (gafferConfigurator != null) {
            gafferConfigurator.run(configFile);
        }
    }

    private static GafferConfigurator newGafferConfiguratorInstance(LoggerContext loggerContext, Object origin2) {
        try {
            Class<?> gcClass = Class.forName("ch.qos.logback.classic.gaffer.GafferConfigurator");
            Constructor<?> c = gcClass.getConstructor(LoggerContext.class);
            return (GafferConfigurator)c.newInstance(loggerContext);
        }
        catch (ClassNotFoundException e) {
            GafferUtil.addError(loggerContext, origin2, ERROR_MSG, e);
        }
        catch (NoSuchMethodException e) {
            GafferUtil.addError(loggerContext, origin2, ERROR_MSG, e);
        }
        catch (InvocationTargetException e) {
            GafferUtil.addError(loggerContext, origin2, ERROR_MSG, e);
        }
        catch (InstantiationException e) {
            GafferUtil.addError(loggerContext, origin2, ERROR_MSG, e);
        }
        catch (IllegalAccessException e) {
            GafferUtil.addError(loggerContext, origin2, ERROR_MSG, e);
        }
        return null;
    }

    private static void addError(LoggerContext context2, Object origin2, String msg) {
        GafferUtil.addError(context2, origin2, msg, null);
    }

    private static void addError(LoggerContext context2, Object origin2, String msg, Throwable t) {
        StatusManager sm = context2.getStatusManager();
        if (sm == null) {
            return;
        }
        sm.add(new ErrorStatus(msg, origin2, t));
    }
}

