/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.StringBuilders;

@AsynchronouslyFormattable
public class StructuredDataMessage
extends MapMessage<StructuredDataMessage, String> {
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;
    private final int maxLength;

    public StructuredDataMessage(String id, String msg, String type2) {
        this(id, msg, type2, 32);
    }

    public StructuredDataMessage(String id, String msg, String type2, int maxLength) {
        this.id = new StructuredDataId(id, null, null, maxLength);
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    public StructuredDataMessage(String id, String msg, String type2, Map<String, String> data2) {
        this(id, msg, type2, data2, 32);
    }

    public StructuredDataMessage(String id, String msg, String type2, Map<String, String> data2, int maxLength) {
        super(data2);
        this.id = new StructuredDataId(id, null, null, maxLength);
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    public StructuredDataMessage(StructuredDataId id, String msg, String type2) {
        this(id, msg, type2, 32);
    }

    public StructuredDataMessage(StructuredDataId id, String msg, String type2, int maxLength) {
        this.id = id;
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    public StructuredDataMessage(StructuredDataId id, String msg, String type2, Map<String, String> data2) {
        this(id, msg, type2, data2, 32);
    }

    public StructuredDataMessage(StructuredDataId id, String msg, String type2, Map<String, String> data2, int maxLength) {
        super(data2);
        this.id = id;
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    private StructuredDataMessage(StructuredDataMessage msg, Map<String, String> map2) {
        super(map2);
        this.id = msg.id;
        this.message = msg.message;
        this.type = msg.type;
        this.maxLength = 32;
    }

    protected StructuredDataMessage() {
        this.maxLength = 32;
    }

    @Override
    public String[] getFormats() {
        String[] formats = new String[Format.values().length];
        int i = 0;
        for (Format format2 : Format.values()) {
            formats[i++] = format2.name();
        }
        return formats;
    }

    public StructuredDataId getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = new StructuredDataId(id, null, null);
    }

    protected void setId(StructuredDataId id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type2) {
        if (type2.length() > 32) {
            throw new IllegalArgumentException("structured data type exceeds maximum length of 32 characters: " + type2);
        }
        this.type = type2;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.asString(Format.FULL, null, buffer);
    }

    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        this.asString(this.getFormat(formats), null, buffer);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    protected void setMessageFormat(String msg) {
        this.message = msg;
    }

    @Override
    public String asString() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String asString(String format2) {
        try {
            return this.asString(EnglishEnums.valueOf(Format.class, format2), null);
        }
        catch (IllegalArgumentException ex) {
            return this.asString();
        }
    }

    public final String asString(Format format2, StructuredDataId structuredDataId) {
        StringBuilder sb = new StringBuilder();
        this.asString(format2, structuredDataId, sb);
        return sb.toString();
    }

    public final void asString(Format format2, StructuredDataId structuredDataId, StringBuilder sb) {
        String msg;
        StructuredDataId sdId;
        boolean full = Format.FULL.equals((Object)format2);
        if (full) {
            String myType = this.getType();
            if (myType == null) {
                return;
            }
            sb.append(this.getType()).append(' ');
        }
        if ((sdId = (sdId = this.getId()) != null ? sdId.makeId(structuredDataId) : structuredDataId) == null || sdId.getName() == null) {
            return;
        }
        if (Format.XML.equals((Object)format2)) {
            this.asXml(sdId, sb);
            return;
        }
        sb.append('[');
        StringBuilders.appendValue(sb, sdId);
        sb.append(' ');
        this.appendMap(sb);
        sb.append(']');
        if (full && (msg = this.getFormat()) != null) {
            sb.append(' ').append(msg);
        }
    }

    private void asXml(StructuredDataId structuredDataId, StringBuilder sb) {
        sb.append("<StructuredData>\n");
        sb.append("<type>").append(this.type).append("</type>\n");
        sb.append("<id>").append(structuredDataId).append("</id>\n");
        super.asXml(sb);
        sb.append("\n</StructuredData>\n");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        return this.asString(this.getFormat(formats), null);
    }

    private Format getFormat(String[] formats) {
        if (formats != null && formats.length > 0) {
            for (int i = 0; i < formats.length; ++i) {
                String format2 = formats[i];
                if (Format.XML.name().equalsIgnoreCase(format2)) {
                    return Format.XML;
                }
                if (!Format.FULL.name().equalsIgnoreCase(format2)) continue;
                return Format.FULL;
            }
            return null;
        }
        return Format.FULL;
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    @Override
    public StructuredDataMessage newInstance(Map<String, String> map2) {
        return new StructuredDataMessage(this, map2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredDataMessage that = (StructuredDataMessage)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        result2 = 31 * result2 + (this.id != null ? this.id.hashCode() : 0);
        result2 = 31 * result2 + (this.message != null ? this.message.hashCode() : 0);
        return result2;
    }

    @Override
    protected void validate(String key, boolean value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, byte value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, char value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, double value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, float value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, int value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, long value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, Object value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, short value) {
        this.validateKey(key);
    }

    @Override
    protected void validate(String key, String value) {
        this.validateKey(key);
    }

    protected void validateKey(String key) {
        if (this.maxLength > 0 && key.length() > this.maxLength) {
            throw new IllegalArgumentException("Structured data keys are limited to " + this.maxLength + " characters. key: " + key);
        }
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= '!' && c <= '~' && c != '=' && c != ']' && c != '\"') continue;
            throw new IllegalArgumentException("Structured data keys must contain printable US ASCII charactersand may not contain a space, =, ], or \"");
        }
    }

    public static enum Format {
        XML,
        FULL;

    }
}

