/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "()V", "renderer", "Lkotlin/reflect/jvm/internal/impl/renderer/DescriptorRenderer;", "renderCallable", "", "descriptor", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "renderFunction", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "renderLambda", "invoke", "renderParameter", "parameter", "Lkotlin/reflect/jvm/internal/KParameterImpl;", "renderProperty", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "renderType", "type", "Lkotlin/reflect/jvm/internal/impl/types/KotlinType;", "appendReceiverType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "receiver", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "appendReceivers", "callable", "kotlin-reflection"})
public final class ReflectionObjectRenderer {
    @NotNull
    public static final ReflectionObjectRenderer INSTANCE = new ReflectionObjectRenderer();
    @NotNull
    private static final DescriptorRenderer renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;

    private ReflectionObjectRenderer() {
    }

    private final void appendReceiverType(StringBuilder $this$appendReceiverType, ReceiverParameterDescriptor receiver2) {
        if (receiver2 != null) {
            KotlinType kotlinType = receiver2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            $this$appendReceiverType.append(this.renderType(kotlinType));
            $this$appendReceiverType.append(".");
        }
    }

    private final void appendReceivers(StringBuilder $this$appendReceivers, CallableDescriptor callable) {
        boolean addParentheses;
        ReceiverParameterDescriptor dispatchReceiver = UtilKt.getInstanceReceiverParameter(callable);
        ReceiverParameterDescriptor extensionReceiver = callable.getExtensionReceiverParameter();
        this.appendReceiverType($this$appendReceivers, dispatchReceiver);
        boolean bl = addParentheses = dispatchReceiver != null && extensionReceiver != null;
        if (addParentheses) {
            $this$appendReceivers.append("(");
        }
        this.appendReceiverType($this$appendReceivers, extensionReceiver);
        if (addParentheses) {
            $this$appendReceivers.append(")");
        }
    }

    private final String renderCallable(CallableDescriptor descriptor2) {
        String string;
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof PropertyDescriptor) {
            string = this.renderProperty((PropertyDescriptor)descriptor2);
        } else if (callableDescriptor instanceof FunctionDescriptor) {
            string = this.renderFunction((FunctionDescriptor)descriptor2);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Illegal callable: ", descriptor2).toString());
        }
        return string;
    }

    @NotNull
    public final String renderProperty(@NotNull PropertyDescriptor descriptor2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        StringBuilder $this$renderProperty_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderProperty_u24lambda_u2d0.append(descriptor2.isVar() ? "var " : "val ");
        INSTANCE.appendReceivers($this$renderProperty_u24lambda_u2d0, descriptor2);
        Object object = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(object, "descriptor.name");
        $this$renderProperty_u24lambda_u2d0.append(renderer.renderName((Name)object, true));
        $this$renderProperty_u24lambda_u2d0.append(": ");
        object = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(object, "descriptor.type");
        $this$renderProperty_u24lambda_u2d0.append(INSTANCE.renderType((KotlinType)object));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderFunction(@NotNull FunctionDescriptor descriptor2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        StringBuilder $this$renderFunction_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderFunction_u24lambda_u2d1.append("fun ");
        INSTANCE.appendReceivers($this$renderFunction_u24lambda_u2d1, descriptor2);
        Object object = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(object, "descriptor.name");
        $this$renderFunction_u24lambda_u2d1.append(renderer.renderName((Name)object, true));
        object = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, "descriptor.valueParameters");
        CollectionsKt.joinTo$default((Iterable)object, $this$renderFunction_u24lambda_u2d1, ", ", "(", ")", 0, null, renderFunction.1.1.INSTANCE, 48, null);
        $this$renderFunction_u24lambda_u2d1.append(": ");
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        object = kotlinType;
        Intrinsics.checkNotNullExpressionValue(object, "descriptor.returnType!!");
        $this$renderFunction_u24lambda_u2d1.append(INSTANCE.renderType((KotlinType)object));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderLambda(@NotNull FunctionDescriptor invoke2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(invoke2, "invoke");
        StringBuilder $this$renderLambda_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendReceivers($this$renderLambda_u24lambda_u2d2, invoke2);
        Object object = invoke2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, "invoke.valueParameters");
        CollectionsKt.joinTo$default((Iterable)object, $this$renderLambda_u24lambda_u2d2, ", ", "(", ")", 0, null, renderLambda.1.1.INSTANCE, 48, null);
        $this$renderLambda_u24lambda_u2d2.append(" -> ");
        KotlinType kotlinType = invoke2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        object = kotlinType;
        Intrinsics.checkNotNullExpressionValue(object, "invoke.returnType!!");
        $this$renderLambda_u24lambda_u2d2.append(INSTANCE.renderType((KotlinType)object));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderParameter(@NotNull KParameterImpl parameter) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        StringBuilder $this$renderParameter_u24lambda_u2d3 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KParameter.Kind kind = parameter.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
        switch (n) {
            case 1: {
                $this$renderParameter_u24lambda_u2d3.append("extension receiver parameter");
                break;
            }
            case 2: {
                $this$renderParameter_u24lambda_u2d3.append("instance parameter");
                break;
            }
            case 3: {
                $this$renderParameter_u24lambda_u2d3.append("parameter #" + parameter.getIndex() + ' ' + parameter.getName());
            }
        }
        $this$renderParameter_u24lambda_u2d3.append(" of ");
        $this$renderParameter_u24lambda_u2d3.append(INSTANCE.renderCallable(parameter.getCallable().getDescriptor()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return renderer.renderType(type2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KParameter.Kind.values().length];
            nArray[KParameter.Kind.EXTENSION_RECEIVER.ordinal()] = 1;
            nArray[KParameter.Kind.INSTANCE.ordinal()] = 2;
            nArray[KParameter.Kind.VALUE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

