/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.core.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.BytePacketBuilderBase;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.io.core.InputPeekKt;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.internal.DangerousInternalIoApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001e\u0010\u0013\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u001a\u0016\u0010\u0015\u001a\u00020\b*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0016"}, d2={"$unsafeAppend$", "", "Lkotlinx/io/core/ByteReadPacket;", "builder", "Lkotlinx/io/core/BytePacketBuilder;", "afterHeadWrite", "Lkotlinx/io/core/Output;", "current", "Lkotlinx/io/core/IoBuffer;", "afterWriteHeadFallback", "completeReadHead", "Lkotlinx/io/core/Input;", "completeReadHeadFallback", "prepareNextReadHeadFallback", "prepareReadFirstHead", "minSize", "", "prepareReadHeadFallback", "prepareReadNextHead", "prepareWriteHead", "capacity", "prepareWriteHeadFallback", "kotlinx-io"})
public final class UnsafeKt {
    @DangerousInternalIoApi
    public static final void $unsafeAppend$(@NotNull ByteReadPacket $this$_u24unsafeAppend_u24, @NotNull BytePacketBuilder builder) {
        block1: {
            Intrinsics.checkParameterIsNotNull($this$_u24unsafeAppend_u24, "$this$_u24unsafeAppend_u24");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            int builderSize = builder.getSize();
            IoBuffer builderHead = builder.getHead();
            if (builderSize <= PacketJVMKt.getPACKET_MAX_COPY_SIZE() && builderHead.getNext() == null && $this$_u24unsafeAppend_u24.tryWriteAppend$kotlinx_io(builderHead)) {
                builder.afterBytesStolen$kotlinx_io();
                return;
            }
            IoBuffer ioBuffer = builder.stealAll$kotlinx_io();
            if (ioBuffer == null) break block1;
            IoBuffer ioBuffer2 = ioBuffer;
            boolean bl = false;
            boolean bl2 = false;
            IoBuffer chain = ioBuffer2;
            boolean bl3 = false;
            $this$_u24unsafeAppend_u24.append$kotlinx_io(chain);
        }
    }

    @DangerousInternalIoApi
    @Nullable
    public static final IoBuffer prepareReadFirstHead(@NotNull Input $this$prepareReadFirstHead, int minSize) {
        Intrinsics.checkParameterIsNotNull($this$prepareReadFirstHead, "$this$prepareReadFirstHead");
        if ($this$prepareReadFirstHead instanceof ByteReadPacketBase) {
            return ((ByteReadPacketBase)$this$prepareReadFirstHead).prepareReadHead(minSize);
        }
        if ($this$prepareReadFirstHead instanceof IoBuffer) {
            return ((IoBuffer)$this$prepareReadFirstHead).canRead() ? (IoBuffer)$this$prepareReadFirstHead : null;
        }
        return UnsafeKt.prepareReadHeadFallback($this$prepareReadFirstHead, minSize);
    }

    private static final IoBuffer prepareReadHeadFallback(@NotNull Input $this$prepareReadHeadFallback, int minSize) {
        if ($this$prepareReadHeadFallback.getEndOfInput()) {
            return null;
        }
        IoBuffer buffer = IoBuffer.Companion.getPool().borrow();
        int rc2 = InputPeekKt.peekTo$default($this$prepareReadHeadFallback, buffer, 0, 0, 0, 14, null);
        if (rc2 < minSize) {
            buffer.release(IoBuffer.Companion.getPool());
            return null;
        }
        return buffer;
    }

    @DangerousInternalIoApi
    public static final void completeReadHead(@NotNull Input $this$completeReadHead, @NotNull IoBuffer current) {
        Intrinsics.checkParameterIsNotNull($this$completeReadHead, "$this$completeReadHead");
        Intrinsics.checkParameterIsNotNull(current, "current");
        if (current == $this$completeReadHead) {
            return;
        }
        if ($this$completeReadHead instanceof ByteReadPacketBase) {
            int remaining = current.getReadRemaining();
            if (remaining == 0) {
                ((ByteReadPacketBase)$this$completeReadHead).ensureNext(current);
            } else if (current.getEndGap() < IoBuffer.Companion.getReservedSize()) {
                ((ByteReadPacketBase)$this$completeReadHead).fixGapAfterRead(current);
            } else {
                ((ByteReadPacketBase)$this$completeReadHead).updateHeadRemaining(remaining);
            }
            return;
        }
        UnsafeKt.completeReadHeadFallback($this$completeReadHead, current);
    }

    private static final void completeReadHeadFallback(@NotNull Input $this$completeReadHeadFallback, IoBuffer current) {
        int discardAmount = current.getCapacity() - current.getWriteRemaining() - current.getReadRemaining();
        InputKt.discardExact($this$completeReadHeadFallback, discardAmount);
        current.release(IoBuffer.Companion.getPool());
    }

    @DangerousInternalIoApi
    @Nullable
    public static final IoBuffer prepareReadNextHead(@NotNull Input $this$prepareReadNextHead, @NotNull IoBuffer current) {
        Intrinsics.checkParameterIsNotNull($this$prepareReadNextHead, "$this$prepareReadNextHead");
        Intrinsics.checkParameterIsNotNull(current, "current");
        if (current == $this$prepareReadNextHead) {
            return ((IoBuffer)$this$prepareReadNextHead).canRead() ? (IoBuffer)$this$prepareReadNextHead : null;
        }
        if ($this$prepareReadNextHead instanceof ByteReadPacketBase) {
            return ((ByteReadPacketBase)$this$prepareReadNextHead).ensureNextHead(current);
        }
        return UnsafeKt.prepareNextReadHeadFallback($this$prepareReadNextHead, current);
    }

    private static final IoBuffer prepareNextReadHeadFallback(@NotNull Input $this$prepareNextReadHeadFallback, IoBuffer current) {
        int discardAmount = current.getCapacity() - current.getWriteRemaining() - current.getReadRemaining();
        InputKt.discardExact($this$prepareNextReadHeadFallback, discardAmount);
        current.resetForWrite();
        if ($this$prepareNextReadHeadFallback.getEndOfInput() || InputPeekKt.peekTo$default($this$prepareNextReadHeadFallback, current, 0, 0, 0, 14, null) <= 0) {
            current.release(IoBuffer.Companion.getPool());
            return null;
        }
        return current;
    }

    @DangerousInternalIoApi
    @NotNull
    public static final IoBuffer prepareWriteHead(@NotNull Output $this$prepareWriteHead, int capacity, @Nullable IoBuffer current) {
        Intrinsics.checkParameterIsNotNull($this$prepareWriteHead, "$this$prepareWriteHead");
        if ($this$prepareWriteHead instanceof BytePacketBuilderBase) {
            return ((BytePacketBuilderBase)$this$prepareWriteHead).prepareWriteHead(capacity);
        }
        return UnsafeKt.prepareWriteHeadFallback($this$prepareWriteHead, current);
    }

    private static final IoBuffer prepareWriteHeadFallback(@NotNull Output $this$prepareWriteHeadFallback, IoBuffer current) {
        if (current != null) {
            OutputKt.writeFully$default($this$prepareWriteHeadFallback, current, 0, 2, null);
            current.resetForWrite();
            return current;
        }
        return IoBuffer.Companion.getPool().borrow();
    }

    @DangerousInternalIoApi
    public static final void afterHeadWrite(@NotNull Output $this$afterHeadWrite, @NotNull IoBuffer current) {
        Intrinsics.checkParameterIsNotNull($this$afterHeadWrite, "$this$afterHeadWrite");
        Intrinsics.checkParameterIsNotNull(current, "current");
        if ($this$afterHeadWrite instanceof BytePacketBuilderBase) {
            ((BytePacketBuilderBase)$this$afterHeadWrite).afterHeadWrite();
            return;
        }
        UnsafeKt.afterWriteHeadFallback($this$afterHeadWrite, current);
    }

    private static final void afterWriteHeadFallback(@NotNull Output $this$afterWriteHeadFallback, IoBuffer current) {
        OutputKt.writeFully$default($this$afterWriteHeadFallback, current, 0, 2, null);
        current.release(IoBuffer.Companion.getPool());
    }
}

