/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.bits.Allocator;
import io.ktor.utils.io.bits.DefaultAllocator;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.IoBuffer;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.pool.DefaultPool;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ktor/utils/io/core/DefaultBufferPool;", "Lio/ktor/utils/io/pool/DefaultPool;", "Lio/ktor/utils/io/core/IoBuffer;", "bufferSize", "", "capacity", "allocator", "Lio/ktor/utils/io/bits/Allocator;", "(IILio/ktor/utils/io/bits/Allocator;)V", "clearInstance", "instance", "disposeInstance", "", "produceInstance", "validateInstance", "ktor-io"})
public final class DefaultBufferPool
extends DefaultPool<IoBuffer> {
    private final int bufferSize;
    private final Allocator allocator;

    @Override
    @NotNull
    protected IoBuffer produceInstance() {
        return new IoBuffer(this.allocator.alloc-SK3TCg8(this.bufferSize), null, this, null);
    }

    @Override
    protected void disposeInstance(@NotNull IoBuffer instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        this.allocator.free-3GNKZMM(instance.getMemory-SK3TCg8());
        super.disposeInstance(instance);
        instance.unlink$ktor_io();
    }

    @Override
    protected void validateInstance(@NotNull IoBuffer instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        super.validateInstance(instance);
        if (instance == IoBuffer.Companion.getEmpty()) {
            String string = "IoBuffer.Empty couldn't be recycled";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean bl = instance != IoBuffer.Companion.getEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Empty instance couldn't be recycled";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = instance != Buffer.Companion.getEmpty();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Empty instance couldn't be recycled";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = instance != ChunkBuffer.Companion.getEmpty();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Empty instance couldn't be recycled";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = instance.getReferenceCount() == 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "Unable to clear buffer: it is still in use.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = instance.getNext() == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl8 = false;
            String string = "Recycled instance shouldn't be a part of a chain.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = instance.getOrigin() == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl9 = false;
            String string = "Recycled instance shouldn't be a view or another buffer.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    protected IoBuffer clearInstance(@NotNull IoBuffer instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        IoBuffer ioBuffer = super.clearInstance(instance);
        boolean bl = false;
        boolean bl2 = false;
        IoBuffer $this$apply = ioBuffer;
        boolean bl3 = false;
        $this$apply.unpark$ktor_io();
        $this$apply.reset();
        return ioBuffer;
    }

    public DefaultBufferPool(int bufferSize, int capacity, @NotNull Allocator allocator) {
        Intrinsics.checkNotNullParameter(allocator, "allocator");
        super(capacity);
        this.bufferSize = bufferSize;
        this.allocator = allocator;
    }

    public /* synthetic */ DefaultBufferPool(int n, int n2, Allocator allocator, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 4096;
        }
        if ((n3 & 2) != 0) {
            n2 = 1000;
        }
        if ((n3 & 4) != 0) {
            allocator = DefaultAllocator.INSTANCE;
        }
        this(n, n2, allocator);
    }

    public DefaultBufferPool() {
        this(0, 0, null, 7, null);
    }
}

