/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.DslMarker;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.mamoe.mirai.utils.ExceptionCollector;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0007\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0015\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0016\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0006\u0010\u001a\u001a\u00020\u0010J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020\u0018H\u0007R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/mamoe/mirai/utils/ExceptionCollector;", "", "()V", "initial", "", "(Ljava/lang/Throwable;)V", "initials", "", "([Ljava/lang/Throwable;)V", "hashCodes", "", "", "last", "asSequence", "Lkotlin/sequences/Sequence;", "beforeCollect", "", "throwable", "collect", "", "e", "collectException", "collectGet", "collectThrow", "", "exception", "dispose", "getLast", "hash", "", "element", "Ljava/lang/StackTraceElement;", "throwLast", "TerminalOperation", "mirai-core-utils"})
public class ExceptionCollector {
    @Nullable
    private volatile Throwable last;
    @NotNull
    private final Set<Long> hashCodes;

    public ExceptionCollector() {
        boolean bl = false;
        this.hashCodes = new LinkedHashSet();
    }

    public ExceptionCollector(@Nullable Throwable initial) {
        boolean bl = false;
        this.hashCodes = new LinkedHashSet();
        this.collect(initial);
    }

    public ExceptionCollector(Throwable ... initials) {
        Intrinsics.checkNotNullParameter(initials, "initials");
        boolean bl = false;
        this.hashCodes = new LinkedHashSet();
        for (Throwable initial : initials) {
            this.collect(initial);
        }
    }

    protected void beforeCollect(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
    }

    public final synchronized boolean collect(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        if (!this.hashCodes.add(this.hash(e))) {
            return false;
        }
        this.beforeCollect(e);
        Throwable throwable = this.last;
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable it = throwable2;
            boolean bl3 = false;
            ExceptionsKt.addSuppressed(e, it);
        }
        this.last = e;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final long hash(Throwable e) {
        void $this$fold$iv;
        Object[] objectArray = e.getStackTrace();
        Intrinsics.checkNotNullExpressionValue(objectArray, "e.stackTrace");
        objectArray = objectArray;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void stackTraceElement;
            StackTraceElement stackTraceElement2 = (StackTraceElement)element$iv;
            long acc = accumulator$iv;
            boolean bl = false;
            long l = acc * (long)31;
            Intrinsics.checkNotNullExpressionValue(stackTraceElement, "stackTraceElement");
            accumulator$iv = l + MiraiUtils.toLongUnsigned(this.hash((StackTraceElement)stackTraceElement));
        }
        return accumulator$iv;
    }

    private final int hash(StackTraceElement element) {
        return Integer.hashCode(element.getLineNumber()) ^ element.getClassName().hashCode() ^ element.getMethodName().hashCode();
    }

    @NotNull
    public final Throwable collectGet(@Nullable Throwable e) {
        this.collect(e);
        Throwable throwable = this.getLast();
        Intrinsics.checkNotNull(throwable);
        return throwable;
    }

    public final boolean collectException(@Nullable Throwable e) {
        return this.collect(e);
    }

    @Nullable
    public final Throwable getLast() {
        return this.last;
    }

    @TerminalOperation
    @NotNull
    public final Void collectThrow(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        this.collect(exception);
        Throwable throwable = this.getLast();
        Intrinsics.checkNotNull(throwable);
        throw throwable;
    }

    @TerminalOperation
    @NotNull
    public final Void throwLast() {
        Throwable throwable = this.getLast();
        if (throwable == null) {
            String string = "Internal error: expected at least one exception collected.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        throw throwable;
    }

    @NotNull
    public final Sequence<Throwable> asSequence() {
        Throwable throwable = this.getLast();
        if (throwable == null) {
            return SequencesKt.emptySequence();
        }
        Throwable last2 = throwable;
        boolean bl = false;
        return new Sequence<Throwable>(last2){
            final /* synthetic */ Throwable $last$inlined;
            {
                this.$last$inlined = throwable;
            }

            @NotNull
            public Iterator<Throwable> iterator() {
                boolean bl = false;
                return ExceptionCollector.access$asSequence$itr(this.$last$inlined);
            }
        };
    }

    public final synchronized void dispose() {
        this.last = null;
        this.hashCodes.clear();
    }

    private static final Iterator<Throwable> asSequence$itr(Throwable $this$asSequence_u24itr) {
        Throwable[] throwableArray = new Throwable[]{$this$asSequence_u24itr};
        Sequence<Throwable> sequence = SequencesKt.sequenceOf(throwableArray);
        throwableArray = $this$asSequence_u24itr.getSuppressed();
        Intrinsics.checkNotNullExpressionValue(throwableArray, "this.suppressed");
        return SequencesKt.plus(sequence, SequencesKt.flatMap(ArraysKt.asSequence((Object[])throwableArray), asSequence.itr.1.INSTANCE)).iterator();
    }

    public static final /* synthetic */ Iterator access$asSequence$itr(Throwable $receiver) {
        return ExceptionCollector.asSequence$itr($receiver);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lnet/mamoe/mirai/utils/ExceptionCollector$TerminalOperation;", "", "mirai-core-utils"})
    @DslMarker
    private static @interface TerminalOperation {
    }
}

