/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapEntryReader;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.RepeatedDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J!\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016\u00a2\u0006\u0002\u0010 J+\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\b\u0010!\u001a\u0004\u0018\u0001H\u001dH\u0014\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\u00020\u00172\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u0010&\u001a\u00020'2\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u0010(\u001a\u00020)2\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u0010*\u001a\u00020+2\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u001c\u0010,\u001a\u00020\u00152\n\u0010$\u001a\u00060\u000ej\u0002`%2\u0006\u0010-\u001a\u00020\u0007H\u0014J\u0014\u0010.\u001a\u00020/2\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u00100\u001a\u00020\u00152\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u00101\u001a\u00020\u000e2\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u00102\u001a\u0002032\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0014\u00104\u001a\u0002052\n\u0010$\u001a\u00060\u000ej\u0002`%H\u0014J\u0012\u00106\u001a\u0002072\b\u0010!\u001a\u0004\u0018\u000107H\u0002J+\u00108\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\b\u0010!\u001a\u0004\u0018\u0001H\u001dH\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u00109\u001a\u00020:2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010;\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0015H\u0002J\u0018\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0015H\u0002J\b\u0010?\u001a\u00020\u0015H\u0002J\u0010\u0010@\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015H\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015H\u0002J\u0010\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020\u0015H\u0002J\u000e\u0010D\u001a\u00020:2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010E\u001a\u00020:2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u0015H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010H\u001a\u00060\u000ej\u0002`%*\u00020\u00072\u0006\u0010C\u001a\u00020\u0015H\u0014R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "reader", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "highReadMarks", "", "indexCache", "", "lowerReadMark", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "sparseIndexCache", "", "", "valueIsNull", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "decodeElementIndex", "decodeNotNullMark", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeTaggedBoolean", "tag", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "decodeTaggedByte", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "enumDescription", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "decodeTaggedShort", "", "decodeTaggedString", "", "deserializeByteArray", "", "deserializeMap", "endStructure", "", "findIndexByTag", "protoTag", "findIndexByTagSlowPath", "desc", "findUnreadElementIndex", "getIndexByTag", "getIndexByTagSlowPath", "markElementAsRead", "index", "populateCache", "populateCacheMap", "elements", "prepareReadMarks", "getTag", "kotlinx-serialization-protobuf"})
public class ProtobufDecoder
extends ProtobufTaggedDecoder {
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @JvmField
    @NotNull
    protected final ProtobufReader reader;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;
    @Nullable
    private int[] indexCache;
    @Nullable
    private Map<Integer, Integer> sparseIndexCache;
    private long lowerReadMark;
    @Nullable
    private final long[] highReadMarks;
    private boolean valueIsNull;

    public ProtobufDecoder(@NotNull ProtoBuf proto, @NotNull ProtobufReader reader, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.proto = proto;
        this.reader = reader;
        this.descriptor = descriptor2;
        this.highReadMarks = this.prepareReadMarks(this.descriptor);
        this.populateCache(this.descriptor);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    private final long[] prepareReadMarks(SerialDescriptor descriptor2) {
        long[] lArray;
        int elementsCount = descriptor2.getElementsCount();
        if (elementsCount <= 64) {
            this.lowerReadMark = elementsCount == 64 ? 0L : -1L << elementsCount;
            lArray = null;
        } else {
            int slotsCount = (elementsCount - 1) / 64;
            int elementsInLastSlot = elementsCount % 64;
            long[] highReadMarks = new long[slotsCount];
            if (elementsInLastSlot != 0) {
                highReadMarks[ArraysKt.getLastIndex((long[])highReadMarks)] = -1L << elementsCount;
            }
            lArray = highReadMarks;
        }
        return lArray;
    }

    public final void populateCache(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        int elements = descriptor2.getElementsCount();
        if (elements < 32) {
            int[] cache = new int[elements + 1];
            int n = 0;
            if (n < elements) {
                do {
                    int i;
                    int protoId;
                    if ((protoId = HelpersKt.extractProtoId(descriptor2, i = n++, false)) > elements) {
                        this.populateCacheMap(descriptor2, elements);
                        return;
                    }
                    cache[protoId] = i;
                } while (n < elements);
            }
            this.indexCache = cache;
        } else {
            this.populateCacheMap(descriptor2, elements);
        }
    }

    private final void populateCacheMap(SerialDescriptor descriptor2, int elements) {
        HashMap map2 = new HashMap(elements);
        int n = 0;
        if (n < elements) {
            do {
                int i = n++;
                Map map3 = map2;
                Integer n2 = HelpersKt.extractProtoId(descriptor2, i, false);
                Integer n3 = i;
                boolean bl = false;
                map3.put(n2, n3);
            } while (n < elements);
        }
        this.sparseIndexCache = map2;
    }

    private final int getIndexByTag(int protoTag) {
        int[] array = this.indexCache;
        if (array != null) {
            int n;
            int[] nArray = array;
            boolean bl = false;
            if (protoTag >= 0 && protoTag <= ArraysKt.getLastIndex(nArray)) {
                n = nArray[protoTag];
            } else {
                int it = protoTag;
                boolean bl2 = false;
                n = -1;
            }
            return n;
        }
        return this.getIndexByTagSlowPath(protoTag);
    }

    private final int getIndexByTagSlowPath(int protoTag) {
        Map<Integer, Integer> map2 = this.sparseIndexCache;
        Intrinsics.checkNotNull(map2);
        Integer n = protoTag;
        boolean bl = false;
        Integer n2 = map2.get(n);
        if (n2 == null) {
            boolean bl2 = false;
            n2 = -1;
        }
        return ((Number)n2).intValue();
    }

    private final int findIndexByTag(SerialDescriptor descriptor2, int protoTag) {
        int protoId;
        if (protoTag < descriptor2.getElementsCount() && (protoId = HelpersKt.extractProtoId(descriptor2, protoTag, true)) == protoTag) {
            return protoTag;
        }
        return this.findIndexByTagSlowPath(descriptor2, protoTag);
    }

    private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
        int n = 0;
        int n2 = desc.getElementsCount();
        if (n < n2) {
            do {
                int i;
                int protoId;
                if ((protoId = HelpersKt.extractProtoId(desc, i = n++, true)) != protoTag) continue;
                return i;
            } while (n < n2);
        }
        throw new ProtobufDecodingException(protoTag + " is not among valid " + this.descriptor.getSerialName() + " enum proto numbers");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            CompositeDecoder compositeDecoder;
            long tag = this.getCurrentTagOrDefault();
            if (Intrinsics.areEqual(this.descriptor.getKind(), StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual(this.descriptor, descriptor2)) {
                void protoId$iv;
                ProtobufReader reader = ProtobufDecodingKt.access$makeDelimited(this.reader, tag);
                reader.readTag();
                boolean bl = true;
                ProtoIntegerType type$iv = ProtoIntegerType.DEFAULT;
                boolean $i$f$ProtoDesc = false;
                compositeDecoder = new RepeatedDecoder(this.proto, reader, type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv, descriptor2);
            } else {
                compositeDecoder = new RepeatedDecoder(this.proto, this.reader, tag, descriptor2);
            }
            return compositeDecoder;
        }
        if ((Intrinsics.areEqual(serialKind, StructureKind.CLASS.INSTANCE) ? true : Intrinsics.areEqual(serialKind, StructureKind.OBJECT.INSTANCE)) ? true : serialKind instanceof PolymorphicKind) {
            long tag = this.getCurrentTagOrDefault();
            if (tag == 19500L && Intrinsics.areEqual(this.descriptor, descriptor2)) {
                return this;
            }
            return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor2);
        }
        if (!Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            throw new SerializationException("Primitives are not supported at top-level");
        }
        return new MapEntryReader(this.proto, ProtobufDecodingKt.access$makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor2);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
    }

    @Override
    protected boolean decodeTaggedBoolean(long tag) {
        boolean bl;
        int value = this.decodeTaggedInt(tag);
        switch (value) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw new SerializationException(Intrinsics.stringPlus("Unexpected boolean value: ", value));
            }
        }
        return bl;
    }

    @Override
    protected byte decodeTaggedByte(long tag) {
        return (byte)this.decodeTaggedInt(tag);
    }

    @Override
    protected short decodeTaggedShort(long tag) {
        return (short)this.decodeTaggedInt(tag);
    }

    @Override
    protected int decodeTaggedInt(long tag) {
        return tag == 19500L ? this.reader.readInt32NoTag() : this.reader.readInt(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected long decodeTaggedLong(long tag) {
        return tag == 19500L ? this.reader.readLongNoTag() : this.reader.readLong(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected float decodeTaggedFloat(long tag) {
        return tag == 19500L ? this.reader.readFloatNoTag() : this.reader.readFloat();
    }

    @Override
    protected double decodeTaggedDouble(long tag) {
        return tag == 19500L ? this.reader.readDoubleNoTag() : this.reader.readDouble();
    }

    @Override
    protected char decodeTaggedChar(long tag) {
        return (char)this.decodeTaggedInt(tag);
    }

    @Override
    @NotNull
    protected String decodeTaggedString(long tag) {
        return tag == 19500L ? this.reader.readStringNoTag() : this.reader.readString();
    }

    @Override
    protected int decodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription) {
        Intrinsics.checkNotNullParameter(enumDescription, "enumDescription");
        return this.findIndexByTag(enumDescription, this.decodeTaggedInt(tag));
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer, null);
    }

    @Override
    protected <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer, @Nullable T previousValue) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return (T)(deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge(this, previousValue) : deserializer.deserialize(this))));
    }

    private final byte[] deserializeByteArray(byte[] previousValue) {
        long tag = this.getCurrentTagOrDefault();
        byte[] array = tag == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
        return previousValue == null ? array : ArraysKt.plus(previousValue, array);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeMap(DeserializationStrategy<T> deserializer, T previousValue) {
        void $this$associateByTo$iv$iv;
        MapLikeSerializer serializer2 = (MapLikeSerializer)deserializer;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer(serializer2.getKeySerializer(), serializer2.getValueSerializer());
        Map map2 = previousValue instanceof Map ? (Map)previousValue : null;
        Set oldSet = map2 == null ? null : map2.entrySet();
        Set setOfEntries = new LinkedHashSetSerializer(mapEntrySerial).merge(this, oldSet);
        Iterable $this$associateBy$iv = setOfEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry it;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Object v = it.getValue();
            map3.put(k, v);
        }
        return (T)destination$iv$iv;
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter($this$getTag, "<this>");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    private final int findUnreadElementIndex() {
        int elementsCount = this.descriptor.getElementsCount();
        while (this.lowerReadMark != -1L) {
            long l = this.lowerReadMark ^ 0xFFFFFFFFFFFFFFFFL;
            boolean bl = false;
            int index = Long.numberOfTrailingZeros(l);
            this.lowerReadMark |= 1L << index;
            if (this.descriptor.isElementOptional(index)) continue;
            SerialDescriptor elementDescriptor2 = this.descriptor.getElementDescriptor(index);
            SerialKind kind = elementDescriptor2.getKind();
            if (Intrinsics.areEqual(kind, StructureKind.MAP.INSTANCE) || Intrinsics.areEqual(kind, StructureKind.LIST.INSTANCE)) {
                return index;
            }
            if (!elementDescriptor2.isNullable()) continue;
            this.valueIsNull = true;
            return index;
        }
        if (elementsCount > 64) {
            long[] lArray = this.highReadMarks;
            Intrinsics.checkNotNull(lArray);
            long[] higherMarks = lArray;
            int n = 0;
            int n2 = higherMarks.length + -1;
            if (n <= n2) {
                do {
                    long mark;
                    int indexInSlot;
                    int slot = n++;
                    int slotOffset = (slot + 1) * 64;
                    for (mark = higherMarks[slot]; mark != -1L; mark |= 1L << indexInSlot) {
                        long l = mark ^ 0xFFFFFFFFFFFFFFFFL;
                        boolean bl = false;
                        indexInSlot = Long.numberOfTrailingZeros(l);
                        int index = slotOffset + indexInSlot;
                        if (this.descriptor.isElementOptional(index)) continue;
                        SerialDescriptor elementDescriptor3 = this.descriptor.getElementDescriptor(index);
                        SerialKind kind = elementDescriptor3.getKind();
                        if (!Intrinsics.areEqual(kind, StructureKind.MAP.INSTANCE) && !Intrinsics.areEqual(kind, StructureKind.LIST.INSTANCE)) continue;
                        higherMarks[slot] = mark;
                        return index;
                    }
                    higherMarks[slot] = mark;
                } while (n <= n2);
            }
            return -1;
        }
        return -1;
    }

    private final void markElementAsRead(int index) {
        if (index < 64) {
            this.lowerReadMark |= 1L << index;
        } else {
            int slot = index / 64 - 1;
            int offsetInSlot = index % 64;
            long[] lArray = this.highReadMarks;
            Intrinsics.checkNotNull(lArray);
            lArray[slot] = this.highReadMarks[slot] | 1L << offsetInSlot;
        }
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int index;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        while (true) {
            int protoId;
            if ((protoId = this.reader.readTag()) == -1) {
                int absenceIndex = this.findUnreadElementIndex();
                return absenceIndex == -1 ? -1 : absenceIndex;
            }
            index = this.getIndexByTag(protoId);
            if (index != -1) break;
            this.reader.skipElement();
        }
        this.markElementAsRead(index);
        return index;
    }

    @Override
    public boolean decodeNotNullMark() {
        boolean bl;
        if (this.valueIsNull) {
            this.valueIsNull = false;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }
}

