/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.model;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.model.ArgumentList;
import kotlin.reflect.jvm.internal.impl.types.model.CaptureStatus;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.DynamicTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentListMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeParameterMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemOptimizationContext;
import kotlin.reflect.jvm.internal.impl.types.model.TypeVariableTypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeSystemContext
extends TypeSystemOptimizationContext {
    @Nullable
    public SimpleTypeMarker asSimpleType(@NotNull KotlinTypeMarker var1);

    @Nullable
    public FlexibleTypeMarker asFlexibleType(@NotNull KotlinTypeMarker var1);

    public boolean isError(@NotNull KotlinTypeMarker var1);

    @Nullable
    public DynamicTypeMarker asDynamicType(@NotNull FlexibleTypeMarker var1);

    @NotNull
    public SimpleTypeMarker upperBound(@NotNull FlexibleTypeMarker var1);

    @NotNull
    public SimpleTypeMarker lowerBound(@NotNull FlexibleTypeMarker var1);

    @Nullable
    public CapturedTypeMarker asCapturedType(@NotNull SimpleTypeMarker var1);

    @Nullable
    public DefinitelyNotNullTypeMarker asDefinitelyNotNullType(@NotNull SimpleTypeMarker var1);

    @NotNull
    public SimpleTypeMarker original(@NotNull DefinitelyNotNullTypeMarker var1);

    @NotNull
    public KotlinTypeMarker makeDefinitelyNotNullOrNotNull(@NotNull KotlinTypeMarker var1);

    public boolean isMarkedNullable(@NotNull SimpleTypeMarker var1);

    public boolean isMarkedNullable(@NotNull KotlinTypeMarker var1);

    @NotNull
    public SimpleTypeMarker withNullability(@NotNull SimpleTypeMarker var1, boolean var2);

    @NotNull
    public TypeConstructorMarker typeConstructor(@NotNull SimpleTypeMarker var1);

    @NotNull
    public KotlinTypeMarker withNullability(@NotNull KotlinTypeMarker var1, boolean var2);

    @NotNull
    public CapturedTypeConstructorMarker typeConstructor(@NotNull CapturedTypeMarker var1);

    @NotNull
    public CaptureStatus captureStatus(@NotNull CapturedTypeMarker var1);

    public boolean isProjectionNotNull(@NotNull CapturedTypeMarker var1);

    @NotNull
    public TypeArgumentMarker projection(@NotNull CapturedTypeConstructorMarker var1);

    public int argumentsCount(@NotNull KotlinTypeMarker var1);

    @NotNull
    public TypeArgumentMarker getArgument(@NotNull KotlinTypeMarker var1, int var2);

    public boolean isStubType(@NotNull SimpleTypeMarker var1);

    @NotNull
    public TypeArgumentMarker asTypeArgument(@NotNull KotlinTypeMarker var1);

    @Nullable
    public KotlinTypeMarker lowerType(@NotNull CapturedTypeMarker var1);

    public boolean isStarProjection(@NotNull TypeArgumentMarker var1);

    @NotNull
    public TypeVariance getVariance(@NotNull TypeArgumentMarker var1);

    @NotNull
    public KotlinTypeMarker getType(@NotNull TypeArgumentMarker var1);

    public int parametersCount(@NotNull TypeConstructorMarker var1);

    @NotNull
    public TypeParameterMarker getParameter(@NotNull TypeConstructorMarker var1, int var2);

    @NotNull
    public Collection<KotlinTypeMarker> supertypes(@NotNull TypeConstructorMarker var1);

    public boolean isIntersection(@NotNull TypeConstructorMarker var1);

    public boolean isClassTypeConstructor(@NotNull TypeConstructorMarker var1);

    public boolean isIntegerLiteralTypeConstructor(@NotNull TypeConstructorMarker var1);

    @Nullable
    public TypeParameterMarker getTypeParameter(@NotNull TypeVariableTypeConstructorMarker var1);

    @NotNull
    public TypeVariance getVariance(@NotNull TypeParameterMarker var1);

    public boolean doesFormSelfType(@NotNull TypeParameterMarker var1, @NotNull TypeConstructorMarker var2);

    public boolean areEqualTypeConstructors(@NotNull TypeConstructorMarker var1, @NotNull TypeConstructorMarker var2);

    public boolean isDenotable(@NotNull TypeConstructorMarker var1);

    @NotNull
    public SimpleTypeMarker lowerBoundIfFlexible(@NotNull KotlinTypeMarker var1);

    @NotNull
    public SimpleTypeMarker upperBoundIfFlexible(@NotNull KotlinTypeMarker var1);

    @NotNull
    public TypeConstructorMarker typeConstructor(@NotNull KotlinTypeMarker var1);

    public boolean isNullableType(@NotNull KotlinTypeMarker var1);

    @NotNull
    public Collection<KotlinTypeMarker> possibleIntegerTypes(@NotNull SimpleTypeMarker var1);

    public boolean isCommonFinalClassConstructor(@NotNull TypeConstructorMarker var1);

    @Nullable
    public SimpleTypeMarker captureFromArguments(@NotNull SimpleTypeMarker var1, @NotNull CaptureStatus var2);

    @NotNull
    public TypeArgumentListMarker asArgumentList(@NotNull SimpleTypeMarker var1);

    @NotNull
    public TypeArgumentMarker get(@NotNull TypeArgumentListMarker var1, int var2);

    public int size(@NotNull TypeArgumentListMarker var1);

    public boolean isAnyConstructor(@NotNull TypeConstructorMarker var1);

    public boolean isNothingConstructor(@NotNull TypeConstructorMarker var1);

    public boolean isSingleClassifierType(@NotNull SimpleTypeMarker var1);

    @NotNull
    public KotlinTypeMarker intersectTypes(@NotNull List<? extends KotlinTypeMarker> var1);

    public boolean isPrimitiveType(@NotNull SimpleTypeMarker var1);

    public static final class DefaultImpls {
        public static boolean isMarkedNullable(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            return receiver2 instanceof SimpleTypeMarker && this_.isMarkedNullable((SimpleTypeMarker)receiver2);
        }

        @Nullable
        public static TypeArgumentMarker getArgumentOrNull(@NotNull TypeSystemContext this_, @NotNull SimpleTypeMarker receiver2, int index) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            boolean bl = 0 <= index ? index < this_.argumentsCount(receiver2) : false;
            if (bl) {
                return this_.getArgument(receiver2, index);
            }
            return null;
        }

        @NotNull
        public static SimpleTypeMarker lowerBoundIfFlexible(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            SimpleTypeMarker simpleTypeMarker;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            FlexibleTypeMarker flexibleTypeMarker = this_.asFlexibleType(receiver2);
            if (flexibleTypeMarker == null) {
                SimpleTypeMarker simpleTypeMarker2 = this_.asSimpleType(receiver2);
                Intrinsics.checkNotNull(simpleTypeMarker2);
                simpleTypeMarker = simpleTypeMarker2;
            } else {
                simpleTypeMarker = this_.lowerBound(flexibleTypeMarker);
            }
            return simpleTypeMarker;
        }

        @NotNull
        public static SimpleTypeMarker upperBoundIfFlexible(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            SimpleTypeMarker simpleTypeMarker;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            FlexibleTypeMarker flexibleTypeMarker = this_.asFlexibleType(receiver2);
            if (flexibleTypeMarker == null) {
                SimpleTypeMarker simpleTypeMarker2 = this_.asSimpleType(receiver2);
                Intrinsics.checkNotNull(simpleTypeMarker2);
                simpleTypeMarker = simpleTypeMarker2;
            } else {
                simpleTypeMarker = this_.upperBound(flexibleTypeMarker);
            }
            return simpleTypeMarker;
        }

        public static boolean isDynamic(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            FlexibleTypeMarker flexibleTypeMarker = this_.asFlexibleType(receiver2);
            return (flexibleTypeMarker == null ? null : this_.asDynamicType(flexibleTypeMarker)) != null;
        }

        public static boolean isDefinitelyNotNullType(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            SimpleTypeMarker simpleTypeMarker = this_.asSimpleType(receiver2);
            return (simpleTypeMarker == null ? null : this_.asDefinitelyNotNullType(simpleTypeMarker)) != null;
        }

        public static boolean hasFlexibleNullability(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            return this_.isMarkedNullable(this_.lowerBoundIfFlexible(receiver2)) != this_.isMarkedNullable(this_.upperBoundIfFlexible(receiver2));
        }

        @NotNull
        public static TypeConstructorMarker typeConstructor(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            SimpleTypeMarker simpleTypeMarker = this_.asSimpleType(receiver2);
            return this_.typeConstructor(simpleTypeMarker == null ? this_.lowerBoundIfFlexible(receiver2) : simpleTypeMarker);
        }

        public static boolean isNothing(@NotNull TypeSystemContext this_, @NotNull KotlinTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            return this_.isNothingConstructor(this_.typeConstructor(receiver2)) && !this_.isNullableType(receiver2);
        }

        public static boolean isClassType(@NotNull TypeSystemContext this_, @NotNull SimpleTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            return this_.isClassTypeConstructor(this_.typeConstructor(receiver2));
        }

        @Nullable
        public static List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull TypeSystemContext this_, @NotNull SimpleTypeMarker receiver2, @NotNull TypeConstructorMarker constructor) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            return null;
        }

        public static boolean isIntegerLiteralType(@NotNull TypeSystemContext this_, @NotNull SimpleTypeMarker receiver2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            return this_.isIntegerLiteralTypeConstructor(this_.typeConstructor(receiver2));
        }

        @NotNull
        public static TypeArgumentMarker get(@NotNull TypeSystemContext this_, @NotNull TypeArgumentListMarker receiver2, int index) {
            TypeArgumentMarker typeArgumentMarker;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            TypeArgumentListMarker typeArgumentListMarker = receiver2;
            if (typeArgumentListMarker instanceof SimpleTypeMarker) {
                typeArgumentMarker = this_.getArgument((KotlinTypeMarker)((Object)receiver2), index);
            } else if (typeArgumentListMarker instanceof ArgumentList) {
                Object e = ((ArgumentList)receiver2).get(index);
                Intrinsics.checkNotNullExpressionValue(e, "get(index)");
                typeArgumentMarker = (TypeArgumentMarker)e;
            } else {
                String string = "unknown type argument list type: " + receiver2 + ", " + Reflection.getOrCreateKotlinClass(receiver2.getClass());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return typeArgumentMarker;
        }

        public static int size(@NotNull TypeSystemContext this_, @NotNull TypeArgumentListMarker receiver2) {
            int n;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver2, "receiver");
            TypeArgumentListMarker typeArgumentListMarker = receiver2;
            if (typeArgumentListMarker instanceof SimpleTypeMarker) {
                n = this_.argumentsCount((KotlinTypeMarker)((Object)receiver2));
            } else if (typeArgumentListMarker instanceof ArgumentList) {
                n = ((ArgumentList)receiver2).size();
            } else {
                String string = "unknown type argument list type: " + receiver2 + ", " + Reflection.getOrCreateKotlinClass(receiver2.getClass());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return n;
        }

        public static boolean identicalArguments(@NotNull TypeSystemContext this_, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return TypeSystemOptimizationContext.DefaultImpls.identicalArguments(this_, a, b);
        }
    }
}

