/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.mamoe.mirai.utils.ConcurrentLinkedQueueKt;
import net.mamoe.mirai.utils.MiraiUtils;
import net.mamoe.mirai.utils.SecretsProtection;
import net.mamoe.mirai.utils.SerializationKt_common;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtectionPlatform;", "", "()V", "bufferSize", "", "lowRemainingHitThreshold", "lowRemainingThreshold", "pool", "Ljava/util/Deque;", "Lnet/mamoe/mirai/utils/SecretsProtectionPlatform$NativeBufferWithLock;", "Lnet/mamoe/mirai/utils/MutableDeque;", "allocate", "Ljava/nio/ByteBuffer;", "size", "escape", "data", "", "impl_asByteArray", "impl_asString", "", "impl_getSize", "EscapedByteBufferSerializer", "EscapedStringSerializer", "NativeBufferWithLock", "mirai-core-utils"})
@SourceDebugExtension(value={"SMAP\nSecretsProtection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretsProtection.kt\nnet/mamoe/mirai/utils/SecretsProtectionPlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JvmNioBuffer.kt\nnet/mamoe/mirai/utils/MiraiUtils__JvmNioBufferKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1855#2:187\n1856#2:191\n28#3:188\n35#3:189\n28#3:190\n25#3,2:192\n28#3:194\n23#3,11:195\n32#3,2:207\n23#3,4:209\n1#4:206\n*S KotlinDebug\n*F\n+ 1 SecretsProtection.kt\nnet/mamoe/mirai/utils/SecretsProtectionPlatform\n*L\n112#1:187\n112#1:191\n114#1:188\n118#1:189\n118#1:190\n153#1:192,2\n169#1:194\n97#1:195,11\n101#1:207,2\n102#1:209,4\n*E\n"})
public final class SecretsProtectionPlatform {
    @NotNull
    public static final SecretsProtectionPlatform INSTANCE = new SecretsProtectionPlatform();
    private static final int bufferSize = RangesKt.coerceAtLeast((int)MiraiUtils.systemProp("mirai.secrets.protection.buffer.size", 0L), 2048);
    private static final int lowRemainingThreshold = bufferSize / 128;
    private static final int lowRemainingHitThreshold = RangesKt.coerceAtLeast((int)MiraiUtils.systemProp("mirai.secrets.protection.threshold.low.remaining.hit", 10L), 1);
    @NotNull
    private static final Deque<NativeBufferWithLock> pool = ConcurrentLinkedQueueKt.ConcurrentLinkedDeque();

    private SecretsProtectionPlatform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final ByteBuffer allocate(int size2) {
        if (size2 >= bufferSize) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size2);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocateDirect(size)");
            return byteBuffer;
        }
        Iterable $this$forEach$iv = pool;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NativeBufferWithLock buffer = (NativeBufferWithLock)element$iv;
            boolean bl = false;
            Buffer $this$remaining$iv = buffer.buffer;
            boolean $i$f$getRemaining = false;
            int bufferRemaining = $this$remaining$iv.remaining();
            if (bufferRemaining >= size2 && buffer.getLock().tryLock()) {
                try {
                    Buffer $this$hasRemaining$iv = buffer.buffer;
                    boolean $i$f$hasRemaining = false;
                    Buffer $this$remaining$iv$iv = $this$hasRemaining$iv;
                    boolean $i$f$getRemaining2 = false;
                    if ($this$remaining$iv$iv.remaining() >= size2) {
                        NativeBufferWithLock.Companion.getUnusedHitUpdater$mirai_core_utils().getAndIncrement(buffer);
                        Intrinsics.checkNotNullExpressionValue(buffer, "buffer");
                        ByteBuffer byteBuffer = SecretsProtectionPlatform.allocate$putInto(size2, buffer);
                        return byteBuffer;
                    }
                }
                finally {
                    buffer.getLock().unlock();
                }
            }
            NativeBufferWithLock.Companion.getUnusedHitUpdater$mirai_core_utils().getAndDecrement(buffer);
            if (bufferRemaining <= lowRemainingThreshold) {
                NativeBufferWithLock.Companion.getLowRemainingHitUpdater$mirai_core_utils().getAndDecrement(buffer);
                if (buffer.lowRemainingHit >= lowRemainingHitThreshold) {
                    pool.remove(buffer);
                }
            }
            if (buffer.unusedHit < 20) continue;
            pool.remove(buffer);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocateDirect(bufferSize)");
        NativeBufferWithLock newBuffer = new NativeBufferWithLock(byteBuffer, null, 0, 0, 14, null);
        ByteBuffer rsp = SecretsProtectionPlatform.allocate$putInto(size2, newBuffer);
        if (newBuffer.buffer.hasRemaining()) {
            pool.add(newBuffer);
        }
        return rsp;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Object escape(@NotNull byte[] data2) {
        void $this$pos$iv;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(data2, "data");
        ByteBuffer it = byteBuffer = SecretsProtectionPlatform.allocate(data2.length);
        boolean bl = false;
        it.put(data2);
        Buffer buffer = it;
        int value$iv = 0;
        boolean $i$f$setPos = false;
        $this$pos$iv.position(value$iv);
        return byteBuffer;
    }

    @NotNull
    public final String impl_asString(@NotNull Object data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        ByteBuffer cfr_ignored_0 = (ByteBuffer)data2;
        ByteBuffer byteBuffer = ((ByteBuffer)data2).duplicate();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "data.duplicate()");
        return MiraiUtils.readString$default(byteBuffer, null, 1, null);
    }

    @NotNull
    public final byte[] impl_asByteArray(@NotNull Object data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        ByteBuffer cfr_ignored_0 = (ByteBuffer)data2;
        ByteBuffer byteBuffer = ((ByteBuffer)data2).duplicate();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "data.duplicate()");
        return MiraiUtils.readBytes(byteBuffer);
    }

    public final int impl_getSize(@NotNull Object data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Buffer $this$remaining$iv = (ByteBuffer)data2;
        boolean $i$f$getRemaining = false;
        return $this$remaining$iv.remaining();
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteBuffer allocate$putInto(int $size, NativeBufferWithLock buffer) {
        void $this$pos$iv;
        Buffer $this$limit$iv;
        ByteBuffer buffer0 = buffer.buffer;
        boolean bl = false;
        Buffer buffer2 = buffer0;
        Buffer $this$pos$iv2 = buffer0;
        boolean $i$f$getPos = false;
        int value$iv = $this$pos$iv2.position() + $size;
        boolean $i$f$setLimit = false;
        $this$limit$iv.limit(value$iv);
        ByteBuffer mirror = buffer0.slice();
        Buffer buf = buffer.buffer;
        boolean bl2 = false;
        $this$limit$iv = buf;
        value$iv = buf.capacity();
        $i$f$setLimit = false;
        $this$limit$iv.limit(value$iv);
        ByteBuffer byteBuffer = buffer.buffer;
        buf = byteBuffer;
        Buffer $this$pos$iv3 = byteBuffer;
        boolean $i$f$getPos2 = false;
        int value$iv2 = $this$pos$iv3.position() + $size;
        boolean $i$f$setPos = false;
        $this$pos$iv.position(value$iv2);
        if (!buffer.buffer.hasRemaining()) {
            pool.remove(buffer);
        }
        Intrinsics.checkNotNullExpressionValue(mirror, "mirror");
        return mirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ByteBuffer tmbuffer = ByteBuffer.allocateDirect(bufferSize);
        if (!MiraiUtils.systemProp("mirai.secrets.protection.ignore.warning", false) && tmbuffer.getClass() == ByteBuffer.allocate(1).getClass()) {
            PrintStream ps = System.err;
            Intrinsics.checkNotNullExpressionValue(ps, "ps");
            PrintStream printStream = ps;
            synchronized (printStream) {
                boolean bl = false;
                ps.println("========================================================================================");
                ps.println("Mirai SecretsProtection WARNING:");
                ps.println();
                ps.println("\u5f53\u524d JRE \u5b9e\u73b0\u6ca1\u6709\u4e3a `ByteBuffer.allocateDirect` \u76f4\u63a5\u5206\u914d\u672c\u5730\u5185\u5b58, \u8bf7\u66f4\u6362\u5176\u4ed6 JRE.");
                ps.println("\u8fd9\u5f88\u6709\u53ef\u80fd\u5bfc\u81f4\u60a8\u7684\u5bc6\u7801\u7b49\u654f\u611f\u4fe1\u606f\u88ab\u5e26\u5165\u5185\u5b58\u62a5\u544a\u4e2d");
                ps.println("\u53ef\u6dfb\u52a0 JVM \u53c2\u6570 -Dmirai.secrets.protection.ignore.warning=true \u6765\u5ffd\u7565\u6b64\u8b66\u544a");
                ps.println();
                ps.println("Current JRE Implementation not using native memory for `ByteBuffer.allocateDirect`.");
                ps.println("Please use another JRE.");
                ps.println("It may cause your passwords to be dumped by other processes.");
                ps.println("Suppress this warning by adding jvm option -Dmirai.secrets.protection.ignore.warning=true");
                ps.println();
                ps.println("========================================================================================");
                Unit unit = Unit.INSTANCE;
            }
        }
        Intrinsics.checkNotNullExpressionValue(tmbuffer, "tmbuffer");
        pool.add(new NativeBufferWithLock(tmbuffer, null, 0, 0, 14, null));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0096\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0001\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0002\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtectionPlatform$EscapedByteBufferSerializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/mamoe/mirai/utils/SecretsProtection$EscapedByteBuffer;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "deserialize-vlT4FJs", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "serialize-D52E_HU", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "mirai-core-utils"})
    @SourceDebugExtension(value={"SMAP\nSecretsProtection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretsProtection.kt\nnet/mamoe/mirai/utils/SecretsProtectionPlatform$EscapedByteBufferSerializer\n+ 2 Serialization.kt\nnet/mamoe/mirai/utils/SerializationKt_common\n*L\n1#1,186:1\n42#2:187\n*S KotlinDebug\n*F\n+ 1 SecretsProtection.kt\nnet/mamoe/mirai/utils/SecretsProtectionPlatform$EscapedByteBufferSerializer\n*L\n179#1:187\n*E\n"})
    public static final class EscapedByteBufferSerializer
    implements KSerializer<SecretsProtection.EscapedByteBuffer> {
        @NotNull
        public static final EscapedByteBufferSerializer INSTANCE = new EscapedByteBufferSerializer();
        private final /* synthetic */ KSerializer<SecretsProtection.EscapedByteBuffer> $$delegate_0;

        /*
         * WARNING - void declaration
         */
        private EscapedByteBufferSerializer() {
            void $this$map$iv;
            KSerializer<byte[]> kSerializer = BuiltinSerializersKt.ByteArraySerializer();
            SerialDescriptor resultantDescriptor$iv = SerializationKt_common.copy(BuiltinSerializersKt.ByteArraySerializer().getDescriptor(), "EscapedByteBuffer");
            boolean $i$f$map = false;
            this.$$delegate_0 = new KSerializer<SecretsProtection.EscapedByteBuffer>(resultantDescriptor$iv, (KSerializer)$this$map$iv){
                final /* synthetic */ SerialDescriptor $resultantDescriptor;
                final /* synthetic */ KSerializer $this_map;
                {
                    this.$resultantDescriptor = $resultantDescriptor;
                    this.$this_map = $receiver;
                }

                @NotNull
                public SerialDescriptor getDescriptor() {
                    return this.$resultantDescriptor;
                }

                /*
                 * WARNING - void declaration
                 */
                public SecretsProtection.EscapedByteBuffer deserialize(@NotNull Decoder decoder) {
                    void it;
                    Intrinsics.checkNotNullParameter(decoder, "decoder");
                    T it2 = this.$this_map.deserialize(decoder);
                    boolean bl = false;
                    byte[] byArray = (byte[])it2;
                    byte[] $this$__delegate_0_u24lambda_u240 = (byte[])it2;
                    boolean bl2 = false;
                    return SecretsProtection.EscapedByteBuffer.box-impl(SecretsProtection.EscapedByteBuffer.constructor-impl(SecretsProtectionPlatform.escape((byte[])it)));
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public void serialize(@NotNull Encoder encoder2, Object value) {
                    void it;
                    void it2;
                    Intrinsics.checkNotNullParameter(encoder2, "encoder");
                    Object object = value;
                    Encoder encoder3 = encoder2;
                    KSerializer kSerializer = this.$this_map;
                    boolean bl = false;
                    Object object2 = ((SecretsProtection.EscapedByteBuffer)it2).unbox-impl();
                    Object $this$__delegate_0_u24lambda_u241 = ((SecretsProtection.EscapedByteBuffer)it2).unbox-impl();
                    boolean bl2 = false;
                    void $this$cast$iv = it;
                    boolean $i$f$cast = false;
                    void v0 = $this$cast$iv;
                    if (v0 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
                    }
                    ByteBuffer byteBuffer = ((ByteBuffer)v0).duplicate();
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "it.data.cast<ByteBuffer>().duplicate()");
                    byte[] byArray = MiraiUtils.readBytes(byteBuffer);
                    kSerializer.serialize(encoder3, byArray);
                }
            };
        }

        @Override
        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.$$delegate_0.getDescriptor();
        }

        @NotNull
        public Object deserialize-vlT4FJs(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter(decoder, "decoder");
            return ((SecretsProtection.EscapedByteBuffer)this.$$delegate_0.deserialize(decoder)).unbox-impl();
        }

        public void serialize-D52E_HU(@NotNull Encoder encoder2, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(encoder2, "encoder");
            Intrinsics.checkNotNullParameter(value, "value");
            this.$$delegate_0.serialize(encoder2, SecretsProtection.EscapedByteBuffer.box-impl(value));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0096\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0001\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0002\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtectionPlatform$EscapedStringSerializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/mamoe/mirai/utils/SecretsProtection$EscapedString;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "deserialize-JIj9kN4", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "serialize-nTZbNTk", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "mirai-core-utils"})
    @SourceDebugExtension(value={"SMAP\nSecretsProtection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretsProtection.kt\nnet/mamoe/mirai/utils/SecretsProtectionPlatform$EscapedStringSerializer\n+ 2 Serialization.kt\nnet/mamoe/mirai/utils/SerializationKt_common\n*L\n1#1,186:1\n42#2:187\n*S KotlinDebug\n*F\n+ 1 SecretsProtection.kt\nnet/mamoe/mirai/utils/SecretsProtectionPlatform$EscapedStringSerializer\n*L\n172#1:187\n*E\n"})
    public static final class EscapedStringSerializer
    implements KSerializer<SecretsProtection.EscapedString> {
        @NotNull
        public static final EscapedStringSerializer INSTANCE = new EscapedStringSerializer();
        private final /* synthetic */ KSerializer<SecretsProtection.EscapedString> $$delegate_0;

        /*
         * WARNING - void declaration
         */
        private EscapedStringSerializer() {
            void $this$map$iv;
            KSerializer<String> kSerializer = BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE);
            SerialDescriptor resultantDescriptor$iv = SerializationKt_common.copy(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE).getDescriptor(), "EscapedString");
            boolean $i$f$map = false;
            this.$$delegate_0 = new KSerializer<SecretsProtection.EscapedString>(resultantDescriptor$iv, (KSerializer)$this$map$iv){
                final /* synthetic */ SerialDescriptor $resultantDescriptor;
                final /* synthetic */ KSerializer $this_map;
                {
                    this.$resultantDescriptor = $resultantDescriptor;
                    this.$this_map = $receiver;
                }

                @NotNull
                public SerialDescriptor getDescriptor() {
                    return this.$resultantDescriptor;
                }

                /*
                 * WARNING - void declaration
                 */
                public SecretsProtection.EscapedString deserialize(@NotNull Decoder decoder) {
                    void it;
                    Intrinsics.checkNotNullParameter(decoder, "decoder");
                    T it2 = this.$this_map.deserialize(decoder);
                    boolean bl = false;
                    String string = (String)it2;
                    String $this$__delegate_0_u24lambda_u240 = (String)it2;
                    boolean bl2 = false;
                    byte[] byArray = it.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                    return SecretsProtection.EscapedString.box-impl(SecretsProtection.EscapedString.constructor-impl(SecretsProtectionPlatform.escape(byArray)));
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public void serialize(@NotNull Encoder encoder2, Object value) {
                    void it;
                    void it2;
                    Intrinsics.checkNotNullParameter(encoder2, "encoder");
                    Object object = value;
                    Encoder encoder3 = encoder2;
                    KSerializer kSerializer = this.$this_map;
                    boolean bl = false;
                    Object object2 = ((SecretsProtection.EscapedString)it2).unbox-impl();
                    Object $this$__delegate_0_u24lambda_u241 = ((SecretsProtection.EscapedString)it2).unbox-impl();
                    boolean bl2 = false;
                    void $this$cast$iv = it;
                    boolean $i$f$cast = false;
                    void v0 = $this$cast$iv;
                    if (v0 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
                    }
                    ByteBuffer byteBuffer = ((ByteBuffer)v0).duplicate();
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "it.data.cast<ByteBuffer>().duplicate()");
                    String string = MiraiUtils.readString$default(byteBuffer, null, 1, null);
                    kSerializer.serialize(encoder3, string);
                }
            };
        }

        @Override
        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.$$delegate_0.getDescriptor();
        }

        @NotNull
        public Object deserialize-JIj9kN4(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter(decoder, "decoder");
            return ((SecretsProtection.EscapedString)this.$$delegate_0.deserialize(decoder)).unbox-impl();
        }

        public void serialize-nTZbNTk(@NotNull Encoder encoder2, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(encoder2, "encoder");
            Intrinsics.checkNotNullParameter(value, "value");
            this.$$delegate_0.serialize(encoder2, SecretsProtection.EscapedString.box-impl(value));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtectionPlatform$NativeBufferWithLock;", "", "buffer", "Ljava/nio/ByteBuffer;", "lock", "Ljava/util/concurrent/locks/Lock;", "lowRemainingHit", "", "unusedHit", "(Ljava/nio/ByteBuffer;Ljava/util/concurrent/locks/Lock;II)V", "getLock", "()Ljava/util/concurrent/locks/Lock;", "Companion", "mirai-core-utils"})
    private static final class NativeBufferWithLock {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final ByteBuffer buffer;
        @NotNull
        private final Lock lock;
        @JvmField
        public volatile int lowRemainingHit;
        @JvmField
        public volatile int unusedHit;
        private static final AtomicIntegerFieldUpdater<NativeBufferWithLock> lowRemainingHitUpdater = AtomicIntegerFieldUpdater.newUpdater(NativeBufferWithLock.class, "lowRemainingHit");
        private static final AtomicIntegerFieldUpdater<NativeBufferWithLock> unusedHitUpdater = AtomicIntegerFieldUpdater.newUpdater(NativeBufferWithLock.class, "unusedHit");

        public NativeBufferWithLock(@NotNull ByteBuffer buffer, @NotNull Lock lock, int lowRemainingHit, int unusedHit) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Intrinsics.checkNotNullParameter(lock, "lock");
            this.buffer = buffer;
            this.lock = lock;
            this.lowRemainingHit = lowRemainingHit;
            this.unusedHit = unusedHit;
        }

        public /* synthetic */ NativeBufferWithLock(ByteBuffer byteBuffer, Lock lock, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                lock = new ReentrantLock();
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(byteBuffer, lock, n, n2);
        }

        @NotNull
        public final Lock getLock() {
            return this.lock;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR8\u0010\t\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtectionPlatform$NativeBufferWithLock$Companion;", "", "()V", "lowRemainingHitUpdater", "Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;", "Lnet/mamoe/mirai/utils/SecretsProtectionPlatform$NativeBufferWithLock;", "kotlin.jvm.PlatformType", "getLowRemainingHitUpdater$mirai_core_utils", "()Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;", "unusedHitUpdater", "getUnusedHitUpdater$mirai_core_utils", "mirai-core-utils"})
        public static final class Companion {
            private Companion() {
            }

            public final AtomicIntegerFieldUpdater<NativeBufferWithLock> getLowRemainingHitUpdater$mirai_core_utils() {
                return lowRemainingHitUpdater;
            }

            public final AtomicIntegerFieldUpdater<NativeBufferWithLock> getUnusedHitUpdater$mirai_core_utils() {
                return unusedHitUpdater;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

