/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;

public class TextEncoderHelper {
    private TextEncoderHelper() {
    }

    static void encodeTextFallBack(Charset charset, StringBuilder text, ByteBufferDestination destination) {
        byte[] bytes = text.toString().getBytes(charset);
        destination.writeBytes(bytes, 0, bytes.length);
    }

    public static void encodeText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBuffer byteBuf, StringBuilder text, ByteBufferDestination destination) {
        charsetEncoder.reset();
        if (text.length() > charBuf.capacity()) {
            TextEncoderHelper.encodeChunkedText(charsetEncoder, charBuf, byteBuf, text, destination);
            return;
        }
        charBuf.clear();
        text.getChars(0, text.length(), charBuf.array(), charBuf.arrayOffset());
        charBuf.limit(text.length());
        CoderResult result2 = charsetEncoder.encode(charBuf, byteBuf, true);
        TextEncoderHelper.writeEncodedText(charsetEncoder, charBuf, byteBuf, destination, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEncodedText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBuffer byteBuf, ByteBufferDestination destination, CoderResult result2) {
        if (!result2.isUnderflow()) {
            TextEncoderHelper.writeChunkedEncodedText(charsetEncoder, charBuf, destination, byteBuf, result2);
            return;
        }
        result2 = charsetEncoder.flush(byteBuf);
        if (!result2.isUnderflow()) {
            ByteBufferDestination byteBufferDestination = destination;
            synchronized (byteBufferDestination) {
                TextEncoderHelper.flushRemainingBytes(charsetEncoder, destination, byteBuf);
            }
            return;
        }
        if (byteBuf != destination.getByteBuffer()) {
            byteBuf.flip();
            destination.writeBytes(byteBuf);
            byteBuf.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChunkedEncodedText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBufferDestination destination, ByteBuffer byteBuf, CoderResult result2) {
        ByteBufferDestination byteBufferDestination = destination;
        synchronized (byteBufferDestination) {
            byteBuf = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuf, true, destination, byteBuf, result2);
            TextEncoderHelper.flushRemainingBytes(charsetEncoder, destination, byteBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encodeChunkedText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBuffer byteBuf, StringBuilder text, ByteBufferDestination destination) {
        int start2 = 0;
        CoderResult result2 = CoderResult.UNDERFLOW;
        boolean endOfInput = false;
        while (!endOfInput && result2.isUnderflow()) {
            charBuf.clear();
            int copied2 = TextEncoderHelper.copy(text, start2, charBuf);
            endOfInput = (start2 += copied2) >= text.length();
            charBuf.flip();
            result2 = charsetEncoder.encode(charBuf, byteBuf, endOfInput);
        }
        if (endOfInput) {
            TextEncoderHelper.writeEncodedText(charsetEncoder, charBuf, byteBuf, destination, result2);
            return;
        }
        ByteBufferDestination byteBufferDestination = destination;
        synchronized (byteBufferDestination) {
            byteBuf = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuf, endOfInput, destination, byteBuf, result2);
            while (!endOfInput) {
                result2 = CoderResult.UNDERFLOW;
                while (!endOfInput && result2.isUnderflow()) {
                    charBuf.clear();
                    int copied3 = TextEncoderHelper.copy(text, start2, charBuf);
                    endOfInput = (start2 += copied3) >= text.length();
                    charBuf.flip();
                    result2 = charsetEncoder.encode(charBuf, byteBuf, endOfInput);
                }
                byteBuf = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuf, endOfInput, destination, byteBuf, result2);
            }
            TextEncoderHelper.flushRemainingBytes(charsetEncoder, destination, byteBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void encodeText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBufferDestination destination) {
        charsetEncoder.reset();
        ByteBufferDestination byteBufferDestination = destination;
        synchronized (byteBufferDestination) {
            ByteBuffer byteBuf = destination.getByteBuffer();
            byteBuf = TextEncoderHelper.encodeAsMuchAsPossible(charsetEncoder, charBuf, true, destination, byteBuf);
            TextEncoderHelper.flushRemainingBytes(charsetEncoder, destination, byteBuf);
        }
    }

    private static ByteBuffer writeAndEncodeAsMuchAsPossible(CharsetEncoder charsetEncoder, CharBuffer charBuf, boolean endOfInput, ByteBufferDestination destination, ByteBuffer temp, CoderResult result2) {
        while (true) {
            temp = TextEncoderHelper.drainIfByteBufferFull(destination, temp, result2);
            if (!result2.isOverflow()) break;
            result2 = charsetEncoder.encode(charBuf, temp, endOfInput);
        }
        if (!result2.isUnderflow()) {
            TextEncoderHelper.throwException(result2);
        }
        return temp;
    }

    private static void throwException(CoderResult result2) {
        try {
            result2.throwException();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static ByteBuffer encodeAsMuchAsPossible(CharsetEncoder charsetEncoder, CharBuffer charBuf, boolean endOfInput, ByteBufferDestination destination, ByteBuffer temp) {
        CoderResult result2;
        do {
            result2 = charsetEncoder.encode(charBuf, temp, endOfInput);
            temp = TextEncoderHelper.drainIfByteBufferFull(destination, temp, result2);
        } while (result2.isOverflow());
        if (!result2.isUnderflow()) {
            TextEncoderHelper.throwException(result2);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer drainIfByteBufferFull(ByteBufferDestination destination, ByteBuffer temp, CoderResult result2) {
        if (result2.isOverflow()) {
            ByteBufferDestination byteBufferDestination = destination;
            synchronized (byteBufferDestination) {
                ByteBuffer destinationBuffer = destination.getByteBuffer();
                if (destinationBuffer != temp) {
                    temp.flip();
                    ByteBufferDestinationHelper.writeToUnsynchronized(temp, destination);
                    temp.clear();
                    return destination.getByteBuffer();
                }
                return destination.drain(destinationBuffer);
            }
        }
        return temp;
    }

    private static void flushRemainingBytes(CharsetEncoder charsetEncoder, ByteBufferDestination destination, ByteBuffer temp) {
        CoderResult result2;
        do {
            result2 = charsetEncoder.flush(temp);
            temp = TextEncoderHelper.drainIfByteBufferFull(destination, temp, result2);
        } while (result2.isOverflow());
        if (!result2.isUnderflow()) {
            TextEncoderHelper.throwException(result2);
        }
        if (temp.remaining() > 0 && temp != destination.getByteBuffer()) {
            temp.flip();
            ByteBufferDestinationHelper.writeToUnsynchronized(temp, destination);
            temp.clear();
        }
    }

    static int copy(StringBuilder source, int offset, CharBuffer destination) {
        int length2 = Math.min(source.length() - offset, destination.remaining());
        char[] array = destination.array();
        int start2 = destination.position();
        source.getChars(offset, offset + length2, array, destination.arrayOffset() + start2);
        destination.position(start2 + length2);
        return length2;
    }
}

