/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;

public class ThreadContextDataInjector {
    private static final Logger LOGGER = StatusLogger.getLogger();
    public static Collection<ContextDataProvider> contextDataProviders = new ConcurrentLinkedDeque<ContextDataProvider>();
    private static final List<ContextDataProvider> SERVICE_PROVIDERS = ThreadContextDataInjector.getServiceProviders();

    @Deprecated
    public static void initServiceProviders() {
    }

    private static List<ContextDataProvider> getServiceProviders() {
        ArrayList<ContextDataProvider> providers = new ArrayList<ContextDataProvider>();
        for (ClassLoader classLoader : LoaderUtil.getClassLoaders()) {
            try {
                for (ContextDataProvider provider : ServiceLoader.load(ContextDataProvider.class, classLoader)) {
                    if (!providers.stream().noneMatch(p -> p.getClass().isAssignableFrom(provider.getClass()))) continue;
                    providers.add(provider);
                }
            }
            catch (Throwable ex) {
                LOGGER.debug("Unable to access Context Data Providers {}", (Object)ex.getMessage());
            }
        }
        return Collections.unmodifiableList(providers);
    }

    public static void copyProperties(List<Property> properties2, StringMap result2) {
        if (properties2 != null) {
            for (int i = 0; i < properties2.size(); ++i) {
                Property prop = properties2.get(i);
                result2.putValue(prop.getName(), prop.getValue());
            }
        }
    }

    private static List<ContextDataProvider> getProviders() {
        ArrayList<ContextDataProvider> providers = new ArrayList<ContextDataProvider>(contextDataProviders.size() + SERVICE_PROVIDERS.size());
        providers.addAll(contextDataProviders);
        providers.addAll(SERVICE_PROVIDERS);
        return providers;
    }

    static /* synthetic */ List access$000() {
        return ThreadContextDataInjector.getProviders();
    }

    public static class ForCopyOnWriteThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$000();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap ignore2) {
            if (this.providers.size() == 1 && (props == null || props.isEmpty())) {
                return this.providers.get(0).supplyStringMap();
            }
            int count2 = props == null ? 0 : props.size();
            StringMap[] maps = new StringMap[this.providers.size()];
            for (int i = 0; i < this.providers.size(); ++i) {
                maps[i] = this.providers.get(i).supplyStringMap();
                count2 += maps[i].size();
            }
            StringMap result2 = ContextDataFactory.createContextData(count2);
            ThreadContextDataInjector.copyProperties(props, result2);
            for (StringMap map2 : maps) {
                result2.putAll(map2);
            }
            return result2;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            return ThreadContext.getThreadContextMap().getReadOnlyContextData();
        }
    }

    public static class ForGarbageFreeThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$000();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap reusable) {
            ThreadContextDataInjector.copyProperties(props, reusable);
            for (int i = 0; i < this.providers.size(); ++i) {
                reusable.putAll(this.providers.get(i).supplyStringMap());
            }
            return reusable;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            return ThreadContext.getThreadContextMap().getReadOnlyContextData();
        }
    }

    public static class ForDefaultThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$000();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap contextData) {
            Map<Object, Object> copy2;
            if (this.providers.size() == 1) {
                copy2 = this.providers.get(0).supplyContextData();
            } else {
                copy2 = new HashMap();
                for (ContextDataProvider provider : this.providers) {
                    copy2.putAll(provider.supplyContextData());
                }
            }
            if (props == null || props.isEmpty()) {
                return copy2.isEmpty() ? ContextDataFactory.emptyFrozenContextData() : ForDefaultThreadContextMap.frozenStringMap(copy2);
            }
            JdkMapAdapterStringMap result2 = new JdkMapAdapterStringMap(new HashMap<Object, Object>(copy2));
            for (int i = 0; i < props.size(); ++i) {
                Property prop = props.get(i);
                if (copy2.containsKey(prop.getName())) continue;
                result2.putValue(prop.getName(), prop.getValue());
            }
            result2.freeze();
            return result2;
        }

        private static JdkMapAdapterStringMap frozenStringMap(Map<String, String> copy2) {
            JdkMapAdapterStringMap result2 = new JdkMapAdapterStringMap(copy2);
            result2.freeze();
            return result2;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            ReadOnlyThreadContextMap map2 = ThreadContext.getThreadContextMap();
            if (map2 instanceof ReadOnlyStringMap) {
                return (ReadOnlyStringMap)((Object)map2);
            }
            Map<String, String> copy2 = ThreadContext.getImmutableContext();
            return copy2.isEmpty() ? ContextDataFactory.emptyFrozenContextData() : new JdkMapAdapterStringMap(copy2);
        }
    }
}

