/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

public abstract class AbstractStyleNameConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final String style;

    protected AbstractStyleNameConverter(String name, List<PatternFormatter> formatters, String styling) {
        super(name, "style");
        this.formatters = formatters;
        this.style = styling;
    }

    protected static <T extends AbstractStyleNameConverter> T newInstance(Class<T> asnConverterClass, String name, Configuration config2, String[] options2) {
        List<PatternFormatter> formatters = AbstractStyleNameConverter.toPatternFormatterList(config2, options2);
        if (formatters == null) {
            return null;
        }
        try {
            Constructor<T> constructor = asnConverterClass.getConstructor(List.class, String.class);
            return (T)((AbstractStyleNameConverter)constructor.newInstance(formatters, AnsiEscape.createSequence(name)));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    private static List<PatternFormatter> toPatternFormatterList(Configuration config2, String[] options2) {
        if (options2.length == 0 || options2[0] == null) {
            LOGGER.error("No pattern supplied on style for config=" + config2);
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config2);
        if (parser == null) {
            LOGGER.error("No PatternParser created for config=" + config2 + ", options=" + Arrays.toString(options2));
            return null;
        }
        return parser.parse(options2[0]);
    }

    @Override
    @PerformanceSensitive(value={"allocation"})
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start2 = toAppendTo.length();
        for (int i = 0; i < this.formatters.size(); ++i) {
            PatternFormatter formatter = this.formatters.get(i);
            formatter.format(event, toAppendTo);
        }
        if (toAppendTo.length() > start2) {
            toAppendTo.insert(start2, this.style);
            toAppendTo.append(AnsiEscape.getDefaultStyle());
        }
    }

    @Plugin(name="yellow", category="Converter")
    @ConverterKeys(value={"yellow"})
    public static final class Yellow
    extends AbstractStyleNameConverter {
        protected static final String NAME = "yellow";

        public Yellow(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Yellow newInstance(Configuration config2, String[] options2) {
            return Yellow.newInstance(Yellow.class, NAME, config2, options2);
        }
    }

    @Plugin(name="white", category="Converter")
    @ConverterKeys(value={"white"})
    public static final class White
    extends AbstractStyleNameConverter {
        protected static final String NAME = "white";

        public White(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static White newInstance(Configuration config2, String[] options2) {
            return White.newInstance(White.class, NAME, config2, options2);
        }
    }

    @Plugin(name="red", category="Converter")
    @ConverterKeys(value={"red"})
    public static final class Red
    extends AbstractStyleNameConverter {
        protected static final String NAME = "red";

        public Red(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Red newInstance(Configuration config2, String[] options2) {
            return Red.newInstance(Red.class, NAME, config2, options2);
        }
    }

    @Plugin(name="magenta", category="Converter")
    @ConverterKeys(value={"magenta"})
    public static final class Magenta
    extends AbstractStyleNameConverter {
        protected static final String NAME = "magenta";

        public Magenta(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Magenta newInstance(Configuration config2, String[] options2) {
            return Magenta.newInstance(Magenta.class, NAME, config2, options2);
        }
    }

    @Plugin(name="green", category="Converter")
    @ConverterKeys(value={"green"})
    public static final class Green
    extends AbstractStyleNameConverter {
        protected static final String NAME = "green";

        public Green(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Green newInstance(Configuration config2, String[] options2) {
            return Green.newInstance(Green.class, NAME, config2, options2);
        }
    }

    @Plugin(name="cyan", category="Converter")
    @ConverterKeys(value={"cyan"})
    public static final class Cyan
    extends AbstractStyleNameConverter {
        protected static final String NAME = "cyan";

        public Cyan(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Cyan newInstance(Configuration config2, String[] options2) {
            return Cyan.newInstance(Cyan.class, NAME, config2, options2);
        }
    }

    @Plugin(name="blue", category="Converter")
    @ConverterKeys(value={"blue"})
    public static final class Blue
    extends AbstractStyleNameConverter {
        protected static final String NAME = "blue";

        public Blue(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Blue newInstance(Configuration config2, String[] options2) {
            return Blue.newInstance(Blue.class, NAME, config2, options2);
        }
    }

    @Plugin(name="black", category="Converter")
    @ConverterKeys(value={"black"})
    public static final class Black
    extends AbstractStyleNameConverter {
        protected static final String NAME = "black";

        public Black(List<PatternFormatter> formatters, String styling) {
            super(NAME, formatters, styling);
        }

        public static Black newInstance(Configuration config2, String[] options2) {
            return Black.newInstance(Black.class, NAME, config2, options2);
        }
    }
}

