/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CryptoKt;
import io.ktor.util.NonceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nB1\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0018\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/ktor/util/StatelessHmacNonceManager;", "Lio/ktor/util/NonceManager;", "key", "", "algorithm", "", "timeoutMillis", "", "nonceGenerator", "Lkotlin/Function0;", "([BLjava/lang/String;JLkotlin/jvm/functions/Function0;)V", "keySpec", "Ljavax/crypto/spec/SecretKeySpec;", "(Ljavax/crypto/spec/SecretKeySpec;Ljava/lang/String;JLkotlin/jvm/functions/Function0;)V", "getAlgorithm", "()Ljava/lang/String;", "getKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "macLength", "", "getNonceGenerator", "()Lkotlin/jvm/functions/Function0;", "getTimeoutMillis", "()J", "newNonce", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyNonce", "", "nonce", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-utils"})
public final class StatelessHmacNonceManager
implements NonceManager {
    @NotNull
    private final SecretKeySpec keySpec;
    @NotNull
    private final String algorithm;
    private final long timeoutMillis;
    @NotNull
    private final Function0<String> nonceGenerator;
    private final int macLength;

    /*
     * WARNING - void declaration
     */
    public StatelessHmacNonceManager(@NotNull SecretKeySpec keySpec, @NotNull String algorithm, long timeoutMillis, @NotNull Function0<String> nonceGenerator) {
        void mac;
        Intrinsics.checkNotNullParameter(keySpec, "keySpec");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(nonceGenerator, "nonceGenerator");
        this.keySpec = keySpec;
        this.algorithm = algorithm;
        this.timeoutMillis = timeoutMillis;
        this.nonceGenerator = nonceGenerator;
        Mac mac2 = Mac.getInstance(this.algorithm);
        StatelessHmacNonceManager statelessHmacNonceManager = this;
        boolean bl = false;
        mac.init(this.getKeySpec());
        int n = mac.getMacLength();
        statelessHmacNonceManager.macLength = n;
    }

    public /* synthetic */ StatelessHmacNonceManager(SecretKeySpec secretKeySpec, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(secretKeySpec, string, l, (Function0<String>)function0);
    }

    @NotNull
    public final SecretKeySpec getKeySpec() {
        return this.keySpec;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @NotNull
    public final Function0<String> getNonceGenerator() {
        return this.nonceGenerator;
    }

    public StatelessHmacNonceManager(@NotNull byte[] key, @NotNull String algorithm, long timeoutMillis, @NotNull Function0<String> nonceGenerator) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(nonceGenerator, "nonceGenerator");
        this(new SecretKeySpec(key, algorithm), algorithm, timeoutMillis, nonceGenerator);
    }

    public /* synthetic */ StatelessHmacNonceManager(byte[] byArray, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = 2.INSTANCE;
        }
        this(byArray, string, l, (Function0<String>)function0);
    }

    @Override
    @Nullable
    public Object newNonce(@NotNull Continuation<? super String> $completion) {
        Mac mac;
        String random = this.getNonceGenerator().invoke();
        String string = Long.toString(System.nanoTime(), CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
        String time = StringsKt.padStart(string, 16, '0');
        Mac $this$newNonce_u24lambda_u2d1 = mac = Mac.getInstance(this.getAlgorithm());
        boolean bl = false;
        $this$newNonce_u24lambda_u2d1.init(this.getKeySpec());
        byte[] byArray = (random + ':' + time).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        $this$newNonce_u24lambda_u2d1.update(byArray);
        byte[] byArray2 = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue(byArray2, "getInstance(algorithm).a\u2026)\n            }.doFinal()");
        String mac2 = CryptoKt.hex(byArray2);
        return random + '+' + time + '+' + mac2;
    }

    @Override
    @Nullable
    public Object verifyNonce(@NotNull String nonce, @NotNull Continuation<? super Boolean> $completion) {
        Mac mac;
        char[] cArray = new char[]{'+'};
        List parts = StringsKt.split$default((CharSequence)nonce, cArray, false, 0, 6, null);
        if (parts.size() != 3) {
            return Boxing.boxBoolean(false);
        }
        String random = (String)parts.get(0);
        String time = (String)parts.get(1);
        String mac2 = (String)parts.get(2);
        if (random.length() < 8) {
            return Boxing.boxBoolean(false);
        }
        if (mac2.length() != this.macLength * 2) {
            return Boxing.boxBoolean(false);
        }
        if (time.length() != 16) {
            return Boxing.boxBoolean(false);
        }
        long nanoTime = Long.parseLong(time, CharsKt.checkRadix(16));
        if (nanoTime + TimeUnit.MILLISECONDS.toNanos(this.getTimeoutMillis()) < System.nanoTime()) {
            return Boxing.boxBoolean(false);
        }
        Mac $this$verifyNonce_u24lambda_u2d2 = mac = Mac.getInstance(this.getAlgorithm());
        boolean bl = false;
        $this$verifyNonce_u24lambda_u2d2.init(this.getKeySpec());
        byte[] byArray = (random + ':' + time).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        $this$verifyNonce_u24lambda_u2d2.update(byArray);
        byte[] byArray2 = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue(byArray2, "getInstance(algorithm).a\u2026)\n            }.doFinal()");
        String computedMac = CryptoKt.hex(byArray2);
        int validCount = 0;
        int n = 0;
        int n2 = Math.min(computedMac.length(), mac2.length());
        while (n < n2) {
            int i;
            if (computedMac.charAt(i = n++) != mac2.charAt(i)) continue;
            int n3 = validCount;
            validCount = n3 + 1;
        }
        return Boxing.boxBoolean(validCount == this.macLength * 2);
    }
}

