/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0007\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u001a*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u001a \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u000fH\u0002\u001a,\u0010\u0011\u001a\u00020\b*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a$\u0010\u0015\u001a\u00020\b*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"parseQueryString", "Lio/ktor/http/Parameters;", "query", "", "startIndex", "", "limit", "parseQueryStringTo", "", "parametersBuilder", "Lio/ktor/http/ParametersBuilder;", "trimEnd", "start", "end", "text", "", "trimStart", "appendParam", "nameIndex", "equalIndex", "endIndex", "parse", "ktor-http"})
public final class QueryKt {
    @NotNull
    public static final Parameters parseQueryString(@NotNull String query, int startIndex, int limit) {
        Parameters parameters2;
        Intrinsics.checkNotNullParameter(query, "query");
        if (startIndex > StringsKt.getLastIndex(query)) {
            parameters2 = Parameters.Companion.getEmpty();
        } else {
            ParametersBuilder parametersBuilder;
            Parameters.Companion this_$iv = Parameters.Companion;
            boolean $i$f$build = false;
            ParametersBuilder $this$parseQueryString_u24lambda_u2d0 = parametersBuilder = new ParametersBuilder(0, null, 3, null);
            boolean bl = false;
            QueryKt.parse($this$parseQueryString_u24lambda_u2d0, query, startIndex, limit);
            parameters2 = parametersBuilder.build();
        }
        return parameters2;
    }

    public static /* synthetic */ Parameters parseQueryString$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 1000;
        }
        return QueryKt.parseQueryString(string, n, n2);
    }

    public static final void parseQueryStringTo(@NotNull ParametersBuilder parametersBuilder, @NotNull String query, int startIndex, int limit) {
        Intrinsics.checkNotNullParameter(parametersBuilder, "parametersBuilder");
        Intrinsics.checkNotNullParameter(query, "query");
        if (startIndex > StringsKt.getLastIndex(query)) {
            return;
        }
        QueryKt.parse(parametersBuilder, query, startIndex, limit);
    }

    public static /* synthetic */ void parseQueryStringTo$default(ParametersBuilder parametersBuilder, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 1000;
        }
        QueryKt.parseQueryStringTo(parametersBuilder, string, n, n2);
    }

    private static final void parse(ParametersBuilder $this$parse, String query, int startIndex, int limit) {
        int count2 = 0;
        int nameIndex = startIndex;
        int equalIndex = -1;
        int n = startIndex;
        int n2 = StringsKt.getLastIndex(query);
        if (n <= n2) {
            int index;
            do {
                index = n++;
                if (count2 == limit) {
                    return;
                }
                char c = query.charAt(index);
                if (c == '&') {
                    QueryKt.appendParam($this$parse, query, nameIndex, equalIndex, index);
                    nameIndex = index + 1;
                    equalIndex = -1;
                    int n3 = count2;
                    count2 = n3 + 1;
                    continue;
                }
                if (c != '=' || equalIndex != -1) continue;
                equalIndex = index;
            } while (index != n2);
        }
        if (count2 == limit) {
            return;
        }
        QueryKt.appendParam($this$parse, query, nameIndex, equalIndex, query.length());
    }

    private static final void appendParam(ParametersBuilder $this$appendParam, String query, int nameIndex, int equalIndex, int endIndex) {
        if (equalIndex == -1) {
            int spaceNameIndex = QueryKt.trimStart(nameIndex, endIndex, query);
            int spaceEndIndex = QueryKt.trimEnd(spaceNameIndex, endIndex, query);
            if (spaceEndIndex > spaceNameIndex) {
                String string;
                if ($this$appendParam.getUrlEncodingOption().getEncodeKey$ktor_http()) {
                    string = CodecsKt.decodeURLQueryComponent$default(query, spaceNameIndex, spaceEndIndex, false, null, 12, null);
                } else {
                    String string2 = query.substring(spaceNameIndex, spaceEndIndex);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    string = string2;
                }
                String name = string;
                $this$appendParam.appendAll(name, CollectionsKt.emptyList());
            }
        } else {
            int spaceNameIndex = QueryKt.trimStart(nameIndex, equalIndex, query);
            int spaceEqualIndex = QueryKt.trimEnd(spaceNameIndex, equalIndex, query);
            if (spaceEqualIndex > spaceNameIndex) {
                String string;
                String string3;
                if ($this$appendParam.getUrlEncodingOption().getEncodeKey$ktor_http()) {
                    string3 = CodecsKt.decodeURLQueryComponent$default(query, spaceNameIndex, spaceEqualIndex, false, null, 12, null);
                } else {
                    String string4 = query.substring(spaceNameIndex, spaceEqualIndex);
                    Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    string3 = string4;
                }
                String name = string3;
                int spaceValueIndex = QueryKt.trimStart(equalIndex + 1, endIndex, query);
                int spaceEndIndex = QueryKt.trimEnd(spaceValueIndex, endIndex, query);
                if ($this$appendParam.getUrlEncodingOption().getEncodeValue$ktor_http()) {
                    string = CodecsKt.decodeURLQueryComponent$default(query, spaceValueIndex, spaceEndIndex, true, null, 8, null);
                } else {
                    String string5 = query.substring(spaceValueIndex, spaceEndIndex);
                    Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    string = string5;
                }
                String value = string;
                $this$appendParam.append(name, value);
            }
        }
    }

    private static final int trimEnd(int start2, int end2, CharSequence text) {
        int spaceIndex = end2;
        while (spaceIndex > start2 && CharsKt.isWhitespace(text.charAt(spaceIndex - 1))) {
            int n = spaceIndex;
            spaceIndex = n + -1;
        }
        return spaceIndex;
    }

    private static final int trimStart(int start2, int end2, CharSequence query) {
        int spaceIndex = start2;
        while (spaceIndex < end2 && CharsKt.isWhitespace(query.charAt(spaceIndex))) {
            int n = spaceIndex;
            spaceIndex = n + 1;
        }
        return spaceIndex;
    }
}

