/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class UrlConnectionFactory {
    private static int DEFAULT_TIMEOUT;
    private static int connectTimeoutMillis;
    private static int readTimeoutMillis;
    private static final String JSON = "application/json";
    private static final String XML = "application/xml";
    private static final String PROPERTIES = "text/x-java-properties";
    private static final String TEXT = "text/plain";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String NO_PROTOCOLS = "_none";
    public static final String ALLOWED_PROTOCOLS = "log4j2.Configuration.allowedProtocols";

    public static HttpURLConnection createConnection(URL url2, long lastModifiedMillis, SslConfiguration sslConfiguration) throws IOException {
        String[] fileParts;
        String type2;
        PropertiesUtil props = PropertiesUtil.getProperties();
        List<String> allowed = Arrays.asList(Strings.splitList(props.getStringProperty(ALLOWED_PROTOCOLS, HTTPS).toLowerCase(Locale.ROOT)));
        if (allowed.size() == 1 && NO_PROTOCOLS.equals(allowed.get(0))) {
            throw new ProtocolException("No external protocols have been enabled");
        }
        String protocol = url2.getProtocol();
        if (protocol == null) {
            throw new ProtocolException("No protocol was specified on " + url2.toString());
        }
        if (!allowed.contains(protocol)) {
            throw new ProtocolException("Protocol " + protocol + " has not been enabled as an allowed protocol");
        }
        HttpURLConnection urlConnection = (HttpURLConnection)url2.openConnection();
        AuthorizationProvider provider2 = ConfigurationFactory.authorizationProvider(props);
        if (provider2 != null) {
            provider2.addAuthorization(urlConnection);
        }
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setRequestMethod("GET");
        if (connectTimeoutMillis > 0) {
            urlConnection.setConnectTimeout(connectTimeoutMillis);
        }
        if (readTimeoutMillis > 0) {
            urlConnection.setReadTimeout(readTimeoutMillis);
        }
        String contentType2 = UrlConnectionFactory.isXml(type2 = (fileParts = url2.getFile().split("\\."))[fileParts.length - 1].trim()) ? XML : (UrlConnectionFactory.isJson(type2) ? JSON : (UrlConnectionFactory.isProperties(type2) ? PROPERTIES : TEXT));
        urlConnection.setRequestProperty("Content-Type", contentType2);
        if (lastModifiedMillis > 0L) {
            urlConnection.setIfModifiedSince(lastModifiedMillis);
        }
        if (url2.getProtocol().equals(HTTPS) && sslConfiguration != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslConfiguration.getSslSocketFactory());
            if (!sslConfiguration.isVerifyHostName()) {
                ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
            }
        }
        return urlConnection;
    }

    public static URLConnection createConnection(URL url2) throws IOException {
        URLConnection urlConnection = null;
        urlConnection = url2.getProtocol().equals(HTTPS) || url2.getProtocol().equals(HTTP) ? UrlConnectionFactory.createConnection(url2, 0L, SslConfigurationFactory.getSslConfiguration()) : url2.openConnection();
        return urlConnection;
    }

    private static boolean isXml(String type2) {
        return type2.equalsIgnoreCase("xml");
    }

    private static boolean isJson(String type2) {
        return type2.equalsIgnoreCase("json") || type2.equalsIgnoreCase("jsn");
    }

    private static boolean isProperties(String type2) {
        return type2.equalsIgnoreCase("properties");
    }

    static {
        connectTimeoutMillis = DEFAULT_TIMEOUT = 60000;
        readTimeoutMillis = DEFAULT_TIMEOUT;
    }
}

