/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangesSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"parseRangesSpecifier", "Lio/ktor/http/RangesSpecifier;", "rangeSpec", "", "mergeRangesKeepOrder", "", "Lkotlin/ranges/LongRange;", "toLongRanges", "Lio/ktor/http/ContentRange;", "contentLength", "", "ktor-http"})
public final class RangesKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangesSpecifier parseRangesSpecifier(@NotNull String rangeSpec) {
        Intrinsics.checkNotNullParameter(rangeSpec, "rangeSpec");
        try {
            List allRanges;
            String unit;
            block14: {
                block13: {
                    void $this$mapTo$iv$iv;
                    void $this$chomp$iv;
                    int idx$iv22;
                    String string = rangeSpec;
                    String separator$iv = "=";
                    boolean $i$f$chomp = false;
                    int n = idx$iv22 = StringsKt.indexOf$default((CharSequence)$this$chomp$iv, separator$iv, 0, false, 6, null);
                    if (n == -1) {
                        boolean bl = false;
                        return null;
                    }
                    Iterable bl = $this$chomp$iv;
                    int n2 = 0;
                    boolean bl2 = false;
                    String string2 = ((String)((Object)bl)).substring(n2, idx$iv22);
                    Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    bl = $this$chomp$iv;
                    n2 = idx$iv22 + 1;
                    bl2 = false;
                    String string3 = ((String)((Object)bl)).substring(n2);
                    Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
                    Pair<String, String> pair = TuplesKt.to(string2, string3);
                    unit = pair.component1();
                    String allRangesString = pair.component2();
                    char[] idx$iv22 = new char[]{','};
                    Object $this$map$iv = StringsKt.split$default((CharSequence)allRangesString, idx$iv22, false, 0, 6, null);
                    boolean $i$f$map = false;
                    bl = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        ContentRange contentRange;
                        Object object;
                        void it;
                        String string4 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        if (StringsKt.startsWith$default((String)it, "-", false, 2, null)) {
                            object = StringsKt.removePrefix((String)it, (CharSequence)"-");
                            boolean bl4 = false;
                            contentRange = new ContentRange.Suffix(Long.parseLong((String)object));
                        } else {
                            Pair<String, String> pair2;
                            void $this$chomp$iv2;
                            void var15_21 = it;
                            String separator$iv2 = "-";
                            boolean $i$f$chomp2 = false;
                            int idx$iv = StringsKt.indexOf$default((CharSequence)$this$chomp$iv2, separator$iv2, 0, false, 6, null);
                            int n3 = idx$iv;
                            if (n3 == -1) {
                                boolean bl5 = false;
                                pair2 = TuplesKt.to("", "");
                            } else {
                                void var20_28 = $this$chomp$iv2;
                                int n4 = 0;
                                boolean bl6 = false;
                                String string5 = var20_28.substring(n4, idx$iv);
                                Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                var20_28 = $this$chomp$iv2;
                                n4 = idx$iv + 1;
                                bl6 = false;
                                String string6 = var20_28.substring(n4);
                                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
                                pair2 = TuplesKt.to(string5, string6);
                            }
                            object = pair2;
                            String from = (String)((Pair)object).component1();
                            String to = (String)((Pair)object).component2();
                            CharSequence charSequence = to;
                            boolean bl7 = false;
                            if (charSequence.length() > 0) {
                                charSequence = from;
                                bl7 = false;
                                long l = Long.parseLong((String)charSequence);
                                charSequence = to;
                                bl7 = false;
                                contentRange = new ContentRange.Bounded(l, Long.parseLong((String)charSequence));
                            } else {
                                charSequence = from;
                                bl7 = false;
                                contentRange = new ContentRange.TailFrom(Long.parseLong((String)charSequence));
                            }
                        }
                        ContentRange contentRange2 = contentRange;
                        collection.add(contentRange2);
                    }
                    allRanges = (List)destination$iv$iv;
                    if (allRanges.isEmpty()) break block13;
                    $this$map$iv = unit;
                    n = 0;
                    if (!($this$map$iv.length() == 0)) break block14;
                }
                return null;
            }
            RangesSpecifier spec = new RangesSpecifier(unit, (List<? extends ContentRange>)allRanges);
            return RangesSpecifier.isValid$default(spec, null, 1, null) ? spec : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> toLongRanges(@NotNull List<? extends ContentRange> $this$toLongRanges, long contentLength) {
        void $this$filterNotTo$iv$iv;
        LongRange it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toLongRanges, "<this>");
        Iterable $this$map$iv = $this$toLongRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LongRange longRange;
            ContentRange contentRange = (ContentRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LongRange longRange2 = it;
            if (longRange2 instanceof ContentRange.Bounded) {
                longRange = new LongRange(((ContentRange.Bounded)((Object)it)).getFrom(), kotlin.ranges.RangesKt.coerceAtMost(((ContentRange.Bounded)((Object)it)).getTo(), contentLength - 1L));
            } else if (longRange2 instanceof ContentRange.TailFrom) {
                longRange = kotlin.ranges.RangesKt.until(((ContentRange.TailFrom)((Object)it)).getFrom(), contentLength);
            } else if (longRange2 instanceof ContentRange.Suffix) {
                longRange = kotlin.ranges.RangesKt.until(kotlin.ranges.RangesKt.coerceAtLeast(contentLength - ((ContentRange.Suffix)((Object)it)).getLastCount(), 0L), contentLength);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LongRange longRange3 = longRange;
            collection.add(longRange3);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (LongRange)element$iv$iv;
            boolean bl = false;
            if (it.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> mergeRangesKeepOrder(@NotNull List<LongRange> $this$mergeRangesKeepOrder) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeRangesKeepOrder, "<this>");
        Iterable $this$sortedBy$iv = $this$mergeRangesKeepOrder;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LongRange it = (LongRange)a;
                boolean bl2 = false;
                Comparable comparable = it.getStart();
                it = (LongRange)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getStart();
                return ComparisonsKt.compareValues(comparable2, (Comparable)l);
            }
        });
        ArrayList<Object> initial$iv = new ArrayList<Object>($this$mergeRangesKeepOrder.size());
        boolean bl2 = false;
        ArrayList<Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void range;
            LongRange longRange = (LongRange)element$iv;
            ArrayList<Object> acc = accumulator$iv;
            boolean bl22 = false;
            if (acc.isEmpty()) {
                acc.add(range);
            } else if (((LongRange)CollectionsKt.last((List)acc)).getEndInclusive() < range.getStart() - 1L) {
                acc.add(range);
            } else {
                LongRange last2 = (LongRange)CollectionsKt.last((List)acc);
                long l = last2.getEndInclusive();
                long l2 = range.getEndInclusive();
                boolean bl3 = false;
                acc.set(CollectionsKt.getLastIndex((List)acc), new LongRange(last2.getStart(), Math.max(l, l2)));
            }
            accumulator$iv = acc;
        }
        ArrayList<Object> sortedMerged = accumulator$iv;
        LongRange[] result2 = new LongRange[$this$mergeRangesKeepOrder.size()];
        block1: for (LongRange longRange : sortedMerged) {
            int n = 0;
            int n2 = $this$mergeRangesKeepOrder.size() + -1;
            if (n > n2) continue;
            do {
                int i = n++;
                Intrinsics.checkNotNullExpressionValue(longRange, "range");
                if (!io.ktor.util.RangesKt.contains(longRange, $this$mergeRangesKeepOrder.get(i))) continue;
                result2[i] = longRange;
                continue block1;
            } while (n <= n2);
        }
        return ArraysKt.filterNotNull(result2);
    }
}

