/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.Parameters;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b!\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u000fH\u00c6\u0003Jg\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010+\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\u0007H\u00d6\u0001J\b\u0010.\u001a\u00020\u0005H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012\u00a8\u00060"}, d2={"Lio/ktor/http/Url;", "", "protocol", "Lio/ktor/http/URLProtocol;", "host", "", "specifiedPort", "", "encodedPath", "parameters", "Lio/ktor/http/Parameters;", "fragment", "user", "password", "trailingQuery", "", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/lang/String;Lio/ktor/http/Parameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getEncodedPath", "()Ljava/lang/String;", "getFragment", "getHost", "getParameters", "()Lio/ktor/http/Parameters;", "getPassword", "port", "getPort", "()I", "getProtocol", "()Lio/ktor/http/URLProtocol;", "getSpecifiedPort", "getTrailingQuery", "()Z", "getUser", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "Companion", "ktor-http"})
public final class Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URLProtocol protocol;
    @NotNull
    private final String host;
    private final int specifiedPort;
    @NotNull
    private final String encodedPath;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final String fragment;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    private final boolean trailingQuery;

    public Url(@NotNull URLProtocol protocol, @NotNull String host, int specifiedPort, @NotNull String encodedPath, @NotNull Parameters parameters2, @NotNull String fragment, @Nullable String user, @Nullable String password, boolean trailingQuery) {
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(encodedPath, "encodedPath");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        this.protocol = protocol;
        this.host = host;
        this.specifiedPort = specifiedPort;
        this.encodedPath = encodedPath;
        this.parameters = parameters2;
        this.fragment = fragment;
        this.user = user;
        this.password = password;
        this.trailingQuery = trailingQuery;
        int n = this.specifiedPort;
        n = (1 <= n ? n <= 65536 : false) || this.specifiedPort == 0 ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "port must be between 1 and 65536, or 0 if not set";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final URLProtocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getSpecifiedPort() {
        return this.specifiedPort;
    }

    @NotNull
    public final String getEncodedPath() {
        return this.encodedPath;
    }

    @NotNull
    public final Parameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    public final int getPort() {
        Integer n = this.specifiedPort;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        return n2 == null ? this.protocol.getDefaultPort() : n2.intValue();
    }

    @NotNull
    public String toString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        $this$toString_u24lambda_u2d2.append(this.getProtocol().getName());
        CharSequence charSequence = this.getProtocol().getName();
        if (Intrinsics.areEqual(charSequence, "file")) {
            URLBuilderKt.access$appendFile($this$toString_u24lambda_u2d2, this.getHost(), this.getEncodedPath());
        } else if (Intrinsics.areEqual(charSequence, "mailto")) {
            String string = this.getUser();
            if (string == null) {
                String string2 = "User can't be empty.";
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String userValue = string;
            URLBuilderKt.access$appendMailto($this$toString_u24lambda_u2d2, userValue, this.getHost());
        } else {
            $this$toString_u24lambda_u2d2.append("://");
            $this$toString_u24lambda_u2d2.append(URLBuilderKt.getAuthority(this));
            $this$toString_u24lambda_u2d2.append(URLUtilsKt.getFullPath(this));
            charSequence = this.getFragment();
            boolean bl7 = false;
            if (charSequence.length() > 0) {
                $this$toString_u24lambda_u2d2.append('#');
                $this$toString_u24lambda_u2d2.append(this.getFragment());
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final URLProtocol component1() {
        return this.protocol;
    }

    @NotNull
    public final String component2() {
        return this.host;
    }

    public final int component3() {
        return this.specifiedPort;
    }

    @NotNull
    public final String component4() {
        return this.encodedPath;
    }

    @NotNull
    public final Parameters component5() {
        return this.parameters;
    }

    @NotNull
    public final String component6() {
        return this.fragment;
    }

    @Nullable
    public final String component7() {
        return this.user;
    }

    @Nullable
    public final String component8() {
        return this.password;
    }

    public final boolean component9() {
        return this.trailingQuery;
    }

    @NotNull
    public final Url copy(@NotNull URLProtocol protocol, @NotNull String host, int specifiedPort, @NotNull String encodedPath, @NotNull Parameters parameters2, @NotNull String fragment, @Nullable String user, @Nullable String password, boolean trailingQuery) {
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(encodedPath, "encodedPath");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        return new Url(protocol, host, specifiedPort, encodedPath, parameters2, fragment, user, password, trailingQuery);
    }

    public static /* synthetic */ Url copy$default(Url url2, URLProtocol uRLProtocol, String string, int n, String string2, Parameters parameters2, String string3, String string4, String string5, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            uRLProtocol = url2.protocol;
        }
        if ((n2 & 2) != 0) {
            string = url2.host;
        }
        if ((n2 & 4) != 0) {
            n = url2.specifiedPort;
        }
        if ((n2 & 8) != 0) {
            string2 = url2.encodedPath;
        }
        if ((n2 & 0x10) != 0) {
            parameters2 = url2.parameters;
        }
        if ((n2 & 0x20) != 0) {
            string3 = url2.fragment;
        }
        if ((n2 & 0x40) != 0) {
            string4 = url2.user;
        }
        if ((n2 & 0x80) != 0) {
            string5 = url2.password;
        }
        if ((n2 & 0x100) != 0) {
            bl = url2.trailingQuery;
        }
        return url2.copy(uRLProtocol, string, n, string2, parameters2, string3, string4, string5, bl);
    }

    public int hashCode() {
        int result2 = this.protocol.hashCode();
        result2 = result2 * 31 + this.host.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.specifiedPort);
        result2 = result2 * 31 + this.encodedPath.hashCode();
        result2 = result2 * 31 + this.parameters.hashCode();
        result2 = result2 * 31 + this.fragment.hashCode();
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        result2 = result2 * 31 + (this.password == null ? 0 : this.password.hashCode());
        int n = this.trailingQuery ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Url)) {
            return false;
        }
        Url url2 = (Url)other;
        if (!Intrinsics.areEqual(this.protocol, url2.protocol)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.host, url2.host)) {
            return false;
        }
        if (this.specifiedPort != url2.specifiedPort) {
            return false;
        }
        if (!Intrinsics.areEqual(this.encodedPath, url2.encodedPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.parameters, url2.parameters)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fragment, url2.fragment)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.user, url2.user)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.password, url2.password)) {
            return false;
        }
        return this.trailingQuery == url2.trailingQuery;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/http/Url$Companion;", "", "()V", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

